/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.HashMap;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedCamelContextMBean;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.RefDataFormatTest;
import org.apache.camel.impl.engine.ExplicitCamelContextNameStrategy;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.spi.CamelContextNameStrategy;
import org.apache.camel.spi.DataFormat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedCamelContextTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementNameStrategy().setNamePattern("19-#name#");
        context.setNameStrategy((CamelContextNameStrategy)new ExplicitCamelContextNameStrategy("my-camel-context"));
        context.setDebugging(Boolean.valueOf(true));
        return context;
    }

    @Test
    public void testManagedCamelContextClient() throws Exception {
        ManagedCamelContextMBean client = ((ManagedCamelContext)this.context.getExtension(ManagedCamelContext.class)).getManagedCamelContext();
        Assertions.assertNotNull((Object)client);
        Assertions.assertEquals((Object)"my-camel-context", (Object)client.getCamelId());
        Assertions.assertEquals((Object)"Started", (Object)client.getState());
    }

    @Test
    public void testManagedCamelContext() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getContextObjectName();
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered");
        String name = (String)mbeanServer.getAttribute(on, "CamelId");
        Assertions.assertEquals((Object)"my-camel-context", (Object)name);
        String managementName = (String)mbeanServer.getAttribute(on, "ManagementName");
        Assertions.assertEquals((Object)"19-my-camel-context", (Object)managementName);
        String level = (String)mbeanServer.getAttribute(on, "ManagementStatisticsLevel");
        Assertions.assertEquals((Object)"Default", (Object)level);
        String uptime = (String)mbeanServer.getAttribute(on, "Uptime");
        Assertions.assertNotNull((Object)uptime);
        long uptimeMillis = (Long)mbeanServer.getAttribute(on, "UptimeMillis");
        Assertions.assertTrue((uptimeMillis > 0L ? 1 : 0) != 0);
        String status = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)"Started", (Object)status);
        Boolean messageHistory = (Boolean)mbeanServer.getAttribute(on, "MessageHistory");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)messageHistory);
        Boolean logMask = (Boolean)mbeanServer.getAttribute(on, "LogMask");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)logMask);
        Integer total = (Integer)mbeanServer.getAttribute(on, "TotalRoutes");
        Assertions.assertEquals((int)2, (int)total);
        Integer started = (Integer)mbeanServer.getAttribute(on, "StartedRoutes");
        Assertions.assertEquals((int)2, (int)started);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mbeanServer.invoke(on, "sendBody", new Object[]{"direct:start", "Hello World"}, new String[]{"java.lang.String", "java.lang.Object"});
        this.assertMockEndpointsSatisfied();
        this.resetMocks();
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mbeanServer.invoke(on, "sendStringBody", new Object[]{"direct:start", "Hello World"}, new String[]{"java.lang.String", "java.lang.String"});
        this.assertMockEndpointsSatisfied();
        Object reply = mbeanServer.invoke(on, "requestBody", new Object[]{"direct:foo", "Hello World"}, new String[]{"java.lang.String", "java.lang.Object"});
        Assertions.assertEquals((Object)"Bye World", (Object)reply);
        reply = mbeanServer.invoke(on, "requestStringBody", new Object[]{"direct:foo", "Hello World"}, new String[]{"java.lang.String", "java.lang.String"});
        Assertions.assertEquals((Object)"Bye World", (Object)reply);
        this.resetMocks();
        mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedHeaderReceived("foo", (Object)123);
        HashMap<String, Integer> headers = new HashMap<String, Integer>();
        headers.put("foo", 123);
        mbeanServer.invoke(on, "sendBodyAndHeaders", new Object[]{"direct:start", "Hello World", headers}, new String[]{"java.lang.String", "java.lang.Object", "java.util.Map"});
        this.assertMockEndpointsSatisfied();
        this.resetMocks();
        mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedHeaderReceived("foo", (Object)123);
        reply = mbeanServer.invoke(on, "requestBodyAndHeaders", new Object[]{"direct:start", "Hello World", headers}, new String[]{"java.lang.String", "java.lang.Object", "java.util.Map"});
        Assertions.assertEquals((Object)"Hello World", (Object)reply);
        this.assertMockEndpointsSatisfied();
        Boolean can = (Boolean)mbeanServer.invoke(on, "canSendToEndpoint", new Object[]{"direct:start"}, new String[]{"java.lang.String"});
        Assertions.assertTrue((boolean)can);
        can = (Boolean)mbeanServer.invoke(on, "canSendToEndpoint", new Object[]{"timer:foo"}, new String[]{"java.lang.String"});
        Assertions.assertFalse((boolean)can);
        mbeanServer.invoke(on, "stop", null, null);
    }

    @Test
    public void testManagedCamelContextCreateEndpoint() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getContextObjectName();
        Assertions.assertNull((Object)this.context.hasEndpoint("seda:bar"));
        Object reply = mbeanServer.invoke(on, "createEndpoint", new Object[]{"seda:bar"}, new String[]{"java.lang.String"});
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)reply);
        Assertions.assertNotNull((Object)this.context.hasEndpoint("seda:bar"));
        ObjectName seda = this.getCamelObjectName("endpoints", "seda://bar");
        boolean registered = mbeanServer.isRegistered(seda);
        Assertions.assertTrue((boolean)registered, (String)("Should be registered " + seda));
        reply = mbeanServer.invoke(on, "createEndpoint", new Object[]{"seda:bar"}, new String[]{"java.lang.String"});
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)reply);
        registered = mbeanServer.isRegistered(seda);
        Assertions.assertTrue((boolean)registered, (String)("Should be registered " + seda));
    }

    @Test
    public void testManagedCamelContextRemoveEndpoint() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getContextObjectName();
        Assertions.assertNull((Object)this.context.hasEndpoint("seda:bar"));
        Object reply = mbeanServer.invoke(on, "createEndpoint", new Object[]{"seda:bar"}, new String[]{"java.lang.String"});
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)reply);
        Assertions.assertNotNull((Object)this.context.hasEndpoint("seda:bar"));
        ObjectName seda = this.getCamelObjectName("endpoints", "seda://bar");
        boolean registered = mbeanServer.isRegistered(seda);
        Assertions.assertTrue((boolean)registered, (String)("Should be registered " + seda));
        Object num = mbeanServer.invoke(on, "removeEndpoints", new Object[]{"seda:*"}, new String[]{"java.lang.String"});
        Assertions.assertEquals((Object)1, (Object)num);
        Assertions.assertNull((Object)this.context.hasEndpoint("seda:bar"));
        registered = mbeanServer.isRegistered(seda);
        Assertions.assertFalse((boolean)registered, (String)("Should not be registered " + seda));
        num = mbeanServer.invoke(on, "removeEndpoints", new Object[]{"seda:*"}, new String[]{"java.lang.String"});
        Assertions.assertEquals((Object)0, (Object)num);
        Assertions.assertNull((Object)this.context.hasEndpoint("seda:bar"));
        registered = mbeanServer.isRegistered(seda);
        Assertions.assertFalse((boolean)registered, (String)("Should not be registered " + seda));
    }

    @Test
    public void testLanguageNames() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getContextObjectName();
        Set names = (Set)mbeanServer.invoke(on, "languageNames", null, null);
        Assertions.assertEquals((int)2, (int)names.size());
        Assertions.assertTrue((boolean)names.contains("constant"));
        Assertions.assertTrue((boolean)names.contains("simple"));
    }

    @Test
    public void testComponentNames() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getContextObjectName();
        Set names = (Set)mbeanServer.invoke(on, "componentNames", null, null);
        Assertions.assertEquals((int)3, (int)names.size());
        Assertions.assertTrue((boolean)names.contains("direct"));
        Assertions.assertTrue((boolean)names.contains("mock"));
        Assertions.assertTrue((boolean)names.contains("seda"));
    }

    @Test
    public void testDataFormatNames() throws Exception {
        this.context.getRegistry().bind("reverse", (Object)new RefDataFormatTest.MyReverseDataFormat());
        DataFormat df = this.context.resolveDataFormat("reverse");
        Assertions.assertNotNull((Object)df);
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getContextObjectName();
        Set names = (Set)mbeanServer.invoke(on, "dataFormatNames", null, null);
        Assertions.assertEquals((int)1, (int)names.size());
        Assertions.assertTrue((boolean)names.contains("reverse"));
    }

    @Test
    public void testSourceLocations() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getContextObjectName();
        String xml = (String)mbeanServer.invoke(on, "dumpRoutesSourceLocationsAsXml", null, null);
        Assertions.assertNotNull((Object)xml);
        Assertions.assertTrue((boolean)xml.contains("sourceLocation=\"org.apache.camel.management.ManagedCamelContextTest$1\" sourceLineNumber=\"285\"/>"));
        Assertions.assertTrue((boolean)xml.contains("sourceLocation=\"org.apache.camel.management.ManagedCamelContextTest$1\" sourceLineNumber=\"286\"/>"));
        Assertions.assertTrue((boolean)xml.contains("sourceLocation=\"org.apache.camel.management.ManagedCamelContextTest$1\" sourceLineNumber=\"287\"/>"));
        Assertions.assertTrue((boolean)xml.contains("sourceLocation=\"org.apache.camel.management.ManagedCamelContextTest$1\" sourceLineNumber=\"289\"/>"));
        Assertions.assertTrue((boolean)xml.contains("sourceLocation=\"org.apache.camel.management.ManagedCamelContextTest$1\" sourceLineNumber=\"290\"/>"));
        Assertions.assertTrue((boolean)xml.contains("sourceLocation=\"org.apache.camel.management.ManagedCamelContextTest$1\" sourceLineNumber=\"291\"/>"));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").delay(10L).to("mock:result");
                ((ExpressionNode)this.from("direct:foo").delay(10L).transform((Expression)this.constant("Bye World"))).id("myTransform");
            }
        };
    }
}

