/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.io.ByteArrayInputStream;
import java.util.List;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Exchange;
import org.apache.camel.api.management.mbean.BacklogTracerEventMessage;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class BacklogTracerStreamCachingTest
extends ManagementTestSupport {
    @Test
    public void testBacklogTracerEventMessageStreamCaching() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=" + this.context.getManagementName() + ",type=tracer,name=BacklogTracer");
        Assertions.assertNotNull((Object)on);
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on));
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)enabled, (String)"Should not be enabled");
        Integer size = (Integer)mbeanServer.getAttribute(on, "BacklogSize");
        Assertions.assertEquals((int)1000, (int)size, (String)"Should be 1000");
        Boolean removeOnDump = (Boolean)mbeanServer.getAttribute(on, "RemoveOnDump");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)removeOnDump);
        mbeanServer.setAttribute(on, new Attribute("BodyIncludeStreams", Boolean.TRUE));
        mbeanServer.setAttribute(on, new Attribute("Enabled", Boolean.TRUE));
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        List exchanges = this.getMockEndpoint("mock:bar").getReceivedExchanges();
        List events = (List)mbeanServer.invoke(on, "dumpTracedMessages", new Object[]{"bar"}, new String[]{"java.lang.String"});
        Assertions.assertNotNull((Object)events);
        Assertions.assertEquals((int)1, (int)events.size());
        BacklogTracerEventMessage event1 = (BacklogTracerEventMessage)events.get(0);
        Assertions.assertEquals((Object)"bar", (Object)event1.getToNode());
        Assertions.assertEquals((Object)("    <message exchangeId=\"" + ((Exchange)exchanges.get(0)).getExchangeId() + "\">\n      <body type=\"org.apache.camel.converter.stream.ByteArrayInputStreamCache\">Bye World</body>\n    </message>"), (Object)event1.getMessageAsXml());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                BacklogTracerStreamCachingTest.this.context.setUseBreadcrumb(Boolean.valueOf(false));
                BacklogTracerStreamCachingTest.this.context.setBacklogTracing(Boolean.valueOf(true));
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").streamCaching().process(exchange -> {
                    ByteArrayInputStream is = new ByteArrayInputStream("Bye World".getBytes());
                    exchange.getIn().setBody((Object)is);
                })).log("Got ${body}")).to("mock:bar")).id("bar");
            }
        };
    }
}

