/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.Message;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Validator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedValidatorRegistryTest
extends ManagementTestSupport {
    @Test
    public void testManageValidatorRegistry() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=services,*"), null);
        ArrayList<ObjectName> list = new ArrayList<ObjectName>(set);
        ObjectName on = null;
        for (ObjectName name : list) {
            if (!name.getCanonicalName().contains("DefaultValidatorRegistry")) continue;
            on = name;
            break;
        }
        Assertions.assertNotNull(on, (String)"Should have found ValidatorRegistry");
        Integer max = (Integer)mbeanServer.getAttribute(on, "MaximumCacheSize");
        Assertions.assertEquals((int)1000, (int)max);
        Integer current = (Integer)mbeanServer.getAttribute(on, "Size");
        Assertions.assertEquals((int)3, (int)current);
        current = (Integer)mbeanServer.getAttribute(on, "StaticSize");
        Assertions.assertEquals((int)3, (int)current);
        current = (Integer)mbeanServer.getAttribute(on, "DynamicSize");
        Assertions.assertEquals((int)0, (int)current);
        String source = (String)mbeanServer.getAttribute(on, "Source");
        Assertions.assertTrue((boolean)source.startsWith("ValidatorRegistry"));
        Assertions.assertTrue((boolean)source.endsWith("capacity: 1000]"));
        TabularData data = (TabularData)mbeanServer.invoke(on, "listValidators", null, null);
        Assertions.assertEquals((int)3, (int)data.size());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.validator().type("xml:foo").withUri("direct:transformer");
                this.validator().type("json:test").withExpression(this.body().isNotNull());
                this.validator().type("custom").withJava(MyValidator.class);
                this.from("direct:start").to("mock:result");
            }
        };
    }

    public static class MyValidator
    extends Validator {
        public void validate(Message message, DataType type) throws ValidationException {
        }
    }
}

