/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedRouteAddSecondRouteNotRegisterNewRoutesTest
extends ManagementTestSupport {
    protected RouteBuilder createRouteBuilder() throws Exception {
        this.context.getManagementStrategy().getManagementAgent().setRegisterNewRoutes(Boolean.valueOf(false));
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("foo").to("mock:result");
            }
        };
    }

    @Test
    public void testRouteAddSecondRoute() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName route1 = this.getCamelObjectName("routes", "foo");
        String state = (String)mbeanServer.getAttribute(route1, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state, (String)"Should be started");
        this.log.info(">>>>>>>>>>>>>>>>> adding 2nd route <<<<<<<<<<<<<<");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:bar").routeId("bar").to("mock:bar");
            }
        });
        this.log.info(">>>>>>>>>>>>>>>>> adding 2nd route DONE <<<<<<<<<<<<<<");
        ObjectName route2 = this.getCamelObjectName("routes", "bar");
        Assertions.assertFalse((boolean)mbeanServer.isRegistered(route2), (String)"2nd route should not be registered");
    }
}

