/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedInflightRepositoryTest
extends ManagementTestSupport {
    @Test
    public void testInflightRepository() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").to("mock:a")).process(exchange -> {
                    MBeanServer mbeanServer = ManagedInflightRepositoryTest.this.getMBeanServer();
                    ObjectName name = ManagedInflightRepositoryTest.this.getCamelObjectName("services", "DefaultInflightRepository");
                    Integer size = (Integer)mbeanServer.getAttribute(name, "Size");
                    Assertions.assertEquals((int)1, (int)size);
                    Integer routeSize = (Integer)mbeanServer.invoke(name, "size", new Object[]{"foo"}, new String[]{"java.lang.String"});
                    Assertions.assertEquals((int)1, (int)routeSize);
                })).id("myProcessor")).to("mock:result");
            }
        };
    }
}

