/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedSanitizeTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementStrategy().getManagementAgent().setMask(Boolean.valueOf(true));
        return context;
    }

    @Test
    public void testSanitize() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = this.getCamelObjectName("endpoints", "stub://foo\\?password=xxxxxx&username=foo");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(name), (String)"Should be registered");
        String uri = (String)mbeanServer.getAttribute(name, "EndpointUri");
        Assertions.assertEquals((Object)"stub://foo?password=xxxxxx&username=foo", (Object)uri);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").routeId("foo").to("stub:foo?username=foo&password=secret")).to("mock:result");
                this.from("stub:foo?username=foo&password=secret").routeId("stub").to("mock:stub");
            }
        };
    }
}

