/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class BacklogDebuggerTest
extends ManagementTestSupport {
    @Test
    public void testBacklogDebugger() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=" + this.context.getManagementName() + ",type=tracer,name=BacklogDebugger");
        Assertions.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)enabled, (String)"Should not be enabled");
        mbeanServer.invoke(on, "enableDebugger", null, null);
        enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)enabled, (String)"Should be enabled");
        mbeanServer.invoke(on, "addBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        mock.setSleepForEmptyTest(100L);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Set suspended = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
            Assertions.assertNotNull((Object)suspended);
            Assertions.assertEquals((int)1, (int)suspended.size());
            Assertions.assertEquals((Object)"bar", suspended.iterator().next());
        });
        String xml = (String)mbeanServer.invoke(on, "dumpTracedMessagesAsXml", new Object[]{"bar"}, new String[]{"java.lang.String"});
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        Assertions.assertTrue((boolean)xml.contains("Hello World"), (String)"Should contain our body");
        Assertions.assertTrue((boolean)xml.contains("<toNode>bar</toNode>"), (String)"Should contain bar node");
        this.resetMocks();
        mock.expectedMessageCount(1);
        mbeanServer.invoke(on, "resumeBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        this.assertMockEndpointsSatisfied();
        Set nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        Assertions.assertNotNull((Object)nodes);
        Assertions.assertEquals((int)0, (int)nodes.size());
    }

    @Test
    public void testBacklogDebuggerUpdateBodyExchangePropertyAndHeader() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=" + this.context.getManagementName() + ",type=tracer,name=BacklogDebugger");
        Assertions.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)enabled, (String)"Should not be enabled");
        mbeanServer.invoke(on, "enableDebugger", null, null);
        enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)enabled, (String)"Should be enabled");
        mbeanServer.invoke(on, "addBreakpoint", new Object[]{"foo"}, new String[]{"java.lang.String"});
        mbeanServer.invoke(on, "addBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        mock.setSleepForEmptyTest(100L);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Set nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        Assertions.assertNotNull((Object)nodes);
        Assertions.assertEquals((int)1, (int)nodes.size());
        Assertions.assertEquals((Object)"foo", nodes.iterator().next());
        mbeanServer.invoke(on, "setMessageBodyOnBreakpoint", new Object[]{"foo", "Changed body"}, new String[]{"java.lang.String", "java.lang.Object"});
        mbeanServer.invoke(on, "setMessageHeaderOnBreakpoint", new Object[]{"foo", "beer", "Carlsberg"}, new String[]{"java.lang.String", "java.lang.String", "java.lang.Object"});
        mbeanServer.invoke(on, "setExchangePropertyOnBreakpoint", new Object[]{"foo", "food", "Bratwurst"}, new String[]{"java.lang.String", "java.lang.String", "java.lang.Object"});
        mbeanServer.invoke(on, "resumeBreakpoint", new Object[]{"foo"}, new String[]{"java.lang.String"});
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Set suspended = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
            Assertions.assertNotNull((Object)suspended);
            Assertions.assertEquals((int)1, (int)suspended.size());
            Assertions.assertEquals((Object)"bar", suspended.iterator().next());
        });
        String xml = (String)mbeanServer.invoke(on, "dumpTracedMessagesAsXml", new Object[]{"bar", true}, new String[]{"java.lang.String", "boolean"});
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        Assertions.assertTrue((boolean)xml.contains("Changed body"), (String)"Should contain our body");
        Assertions.assertTrue((boolean)xml.contains("<toNode>bar</toNode>"), (String)"Should contain bar node");
        Assertions.assertTrue((boolean)xml.contains("<header key=\"beer\" type=\"java.lang.String\">Carlsberg</header>"), (String)"Should contain our added header");
        Assertions.assertTrue((boolean)xml.contains("<exchangeProperty name=\"food\" type=\"java.lang.String\">Bratwurst</exchangeProperty>"), (String)"Should contain our added exchange property");
        this.resetMocks();
        mock.expectedMessageCount(1);
        mbeanServer.invoke(on, "resumeBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        this.assertMockEndpointsSatisfied();
        nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        Assertions.assertNotNull((Object)nodes);
        Assertions.assertEquals((int)0, (int)nodes.size());
    }

    @Test
    public void testBacklogDebuggerUpdateBodyExchangePropertyAndHeaderType() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=" + this.context.getManagementName() + ",type=tracer,name=BacklogDebugger");
        Assertions.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)enabled, (String)"Should not be enabled");
        mbeanServer.invoke(on, "enableDebugger", null, null);
        enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)enabled, (String)"Should be enabled");
        mbeanServer.invoke(on, "addBreakpoint", new Object[]{"foo"}, new String[]{"java.lang.String"});
        mbeanServer.invoke(on, "addBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        mock.setSleepForEmptyTest(100L);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Set nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        Assertions.assertNotNull((Object)nodes);
        Assertions.assertEquals((int)1, (int)nodes.size());
        Assertions.assertEquals((Object)"foo", nodes.iterator().next());
        mbeanServer.invoke(on, "setMessageBodyOnBreakpoint", new Object[]{"foo", "444", "java.lang.Integer"}, new String[]{"java.lang.String", "java.lang.Object", "java.lang.String"});
        mbeanServer.invoke(on, "setMessageHeaderOnBreakpoint", new Object[]{"foo", "beer", "123", "java.lang.Integer"}, new String[]{"java.lang.String", "java.lang.String", "java.lang.Object", "java.lang.String"});
        mbeanServer.invoke(on, "setExchangePropertyOnBreakpoint", new Object[]{"foo", "food", "987", "java.lang.Integer"}, new String[]{"java.lang.String", "java.lang.String", "java.lang.Object", "java.lang.String"});
        mbeanServer.invoke(on, "resumeBreakpoint", new Object[]{"foo"}, new String[]{"java.lang.String"});
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Set suspended = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
            Assertions.assertNotNull((Object)suspended);
            Assertions.assertEquals((int)1, (int)suspended.size());
            Assertions.assertEquals((Object)"bar", suspended.iterator().next());
        });
        String xml = (String)mbeanServer.invoke(on, "dumpTracedMessagesAsXml", new Object[]{"bar", true}, new String[]{"java.lang.String", "boolean"});
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        Assertions.assertTrue((boolean)xml.contains("444"), (String)"Should contain our body");
        Assertions.assertTrue((boolean)xml.contains("<toNode>bar</toNode>"), (String)"Should contain bar node");
        Assertions.assertTrue((boolean)xml.contains("<header key=\"beer\" type=\"java.lang.Integer\">123</header>"), (String)"Should contain our added header");
        Assertions.assertTrue((boolean)xml.contains("<exchangeProperty name=\"food\" type=\"java.lang.Integer\">987</exchangeProperty>"), (String)"Should contain our added exchange property");
        this.resetMocks();
        mock.expectedMessageCount(1);
        mbeanServer.invoke(on, "resumeBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        this.assertMockEndpointsSatisfied();
        nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        Assertions.assertNotNull((Object)nodes);
        Assertions.assertEquals((int)0, (int)nodes.size());
    }

    @Test
    public void testBacklogDebuggerRemoveBodyAndHeader() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=" + this.context.getManagementName() + ",type=tracer,name=BacklogDebugger");
        Assertions.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)enabled, (String)"Should not be enabled");
        mbeanServer.invoke(on, "enableDebugger", null, null);
        enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)enabled, (String)"Should be enabled");
        mbeanServer.invoke(on, "addBreakpoint", new Object[]{"foo"}, new String[]{"java.lang.String"});
        mbeanServer.invoke(on, "addBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        mock.setSleepForEmptyTest(100L);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Set nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        Assertions.assertNotNull((Object)nodes);
        Assertions.assertEquals((int)1, (int)nodes.size());
        Assertions.assertEquals((Object)"foo", nodes.iterator().next());
        mbeanServer.invoke(on, "removeMessageBodyOnBreakpoint", new Object[]{"foo"}, new String[]{"java.lang.String"});
        mbeanServer.invoke(on, "removeMessageHeaderOnBreakpoint", new Object[]{"foo", "beer"}, new String[]{"java.lang.String", "java.lang.String"});
        mbeanServer.invoke(on, "removeExchangePropertyOnBreakpoint", new Object[]{"foo", "food"}, new String[]{"java.lang.String", "java.lang.String"});
        mbeanServer.invoke(on, "resumeBreakpoint", new Object[]{"foo"}, new String[]{"java.lang.String"});
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Set suspended = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
            Assertions.assertNotNull((Object)suspended);
            Assertions.assertEquals((int)1, (int)suspended.size());
            Assertions.assertEquals((Object)"bar", suspended.iterator().next());
        });
        String xml = (String)mbeanServer.invoke(on, "dumpTracedMessagesAsXml", new Object[]{"bar", true}, new String[]{"java.lang.String", "boolean"});
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        Assertions.assertTrue((boolean)xml.contains("<body>[Body is null]</body>"), (String)"Should not contain our body");
        Assertions.assertTrue((boolean)xml.contains("<toNode>bar</toNode>"), (String)"Should contain bar node");
        Assertions.assertFalse((boolean)xml.contains("<header"), (String)"Should not contain any headers");
        Assertions.assertFalse((boolean)xml.contains("<exchangeProperty name=\"food\""), (String)"Should not contain exchange property 'food'");
        this.resetMocks();
        mock.expectedMessageCount(1);
        mbeanServer.invoke(on, "resumeBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        this.assertMockEndpointsSatisfied();
        nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        Assertions.assertNotNull((Object)nodes);
        Assertions.assertEquals((int)0, (int)nodes.size());
    }

    @Test
    public void testBacklogDebuggerSuspendOnlyOneAtBreakpoint() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=" + this.context.getManagementName() + ",type=tracer,name=BacklogDebugger");
        Assertions.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)enabled, (String)"Should not be enabled");
        mbeanServer.invoke(on, "enableDebugger", null, null);
        enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)enabled, (String)"Should be enabled");
        mbeanServer.invoke(on, "addBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.template.sendBody("seda:start", (Object)"Hello Camel");
        this.template.sendBody("seda:start", (Object)"Hello Earth");
        this.assertMockEndpointsSatisfied();
        Set nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        Assertions.assertNotNull((Object)nodes);
        Assertions.assertEquals((int)1, (int)nodes.size());
        Assertions.assertEquals((Object)"bar", nodes.iterator().next());
        String xml = (String)mbeanServer.invoke(on, "dumpTracedMessagesAsXml", new Object[]{"bar"}, new String[]{"java.lang.String"});
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        Assertions.assertTrue((boolean)xml.contains("<toNode>bar</toNode>"), (String)"Should contain bar node");
        this.resetMocks();
        mock.expectedMessageCount(1);
        mbeanServer.invoke(on, "resumeBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        this.assertMockEndpointsSatisfied();
        nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        Assertions.assertNotNull((Object)nodes);
        Assertions.assertEquals((int)0, (int)nodes.size());
    }

    @Test
    public void testBacklogDebuggerConditional() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=" + this.context.getManagementName() + ",type=tracer,name=BacklogDebugger");
        Assertions.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)enabled, (String)"Should not be enabled");
        mbeanServer.invoke(on, "enableDebugger", null, null);
        enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)enabled, (String)"Should be enabled");
        Object out = mbeanServer.invoke(on, "validateConditionalBreakpoint", new Object[]{"unknown", "${body contains 'Camel'"}, new String[]{"java.lang.String", "java.lang.String"});
        Assertions.assertEquals((Object)"No language could be found for: unknown", (Object)out);
        out = mbeanServer.invoke(on, "validateConditionalBreakpoint", new Object[]{"simple", "${body contains 'Camel'"}, new String[]{"java.lang.String", "java.lang.String"});
        Assertions.assertNotNull((Object)out);
        Assertions.assertTrue((boolean)out.toString().startsWith("Invalid syntax ${body contains 'Camel'"));
        out = mbeanServer.invoke(on, "validateConditionalBreakpoint", new Object[]{"simple", "${body} contains 'Camel'"}, new String[]{"java.lang.String", "java.lang.String"});
        Assertions.assertNull((Object)out);
        mbeanServer.invoke(on, "addConditionalBreakpoint", new Object[]{"bar", "simple", "${body} contains 'Camel'"}, new String[]{"java.lang.String", "java.lang.String", "java.lang.String"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Set nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        Assertions.assertNotNull((Object)nodes);
        Assertions.assertEquals((int)0, (int)nodes.size());
        this.resetMocks();
        mock.expectedMessageCount(0);
        mock.setSleepForEmptyTest(100L);
        this.template.sendBody("seda:start", (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
        nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        Assertions.assertNotNull((Object)nodes);
        Assertions.assertEquals((int)1, (int)nodes.size());
        Assertions.assertEquals((Object)"bar", nodes.iterator().next());
        String xml = (String)mbeanServer.invoke(on, "dumpTracedMessagesAsXml", new Object[]{"bar"}, new String[]{"java.lang.String"});
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        Assertions.assertTrue((boolean)xml.contains("Hello Camel"), (String)"Should contain our body");
        Assertions.assertTrue((boolean)xml.contains("<toNode>bar</toNode>"), (String)"Should contain bar node");
        this.resetMocks();
        mock.expectedMessageCount(1);
        mbeanServer.invoke(on, "resumeBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        this.assertMockEndpointsSatisfied();
        nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        Assertions.assertNotNull((Object)nodes);
        Assertions.assertEquals((int)0, (int)nodes.size());
    }

    @Test
    public void testBacklogDebuggerStep() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=" + this.context.getManagementName() + ",type=tracer,name=BacklogDebugger");
        Assertions.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)enabled, (String)"Should not be enabled");
        mbeanServer.invoke(on, "enableDebugger", null, null);
        enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)enabled, (String)"Should be enabled");
        mbeanServer.invoke(on, "addBreakpoint", new Object[]{"foo"}, new String[]{"java.lang.String"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        mock.setSleepForEmptyTest(100L);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Set nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        Assertions.assertNotNull((Object)nodes);
        Assertions.assertEquals((int)1, (int)nodes.size());
        Assertions.assertEquals((Object)"foo", nodes.iterator().next());
        Boolean stepMode = (Boolean)mbeanServer.getAttribute(on, "SingleStepMode");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)stepMode, (String)"Should not be in step mode");
        mbeanServer.invoke(on, "stepBreakpoint", new Object[]{"foo"}, new String[]{"java.lang.String"});
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Set suspended = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
            Assertions.assertNotNull((Object)suspended);
            Assertions.assertEquals((int)1, (int)suspended.size());
            Assertions.assertEquals((Object)"bar", suspended.iterator().next());
        });
        mbeanServer.invoke(on, "step", null, null);
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Set suspended = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
            Assertions.assertNotNull((Object)suspended);
            Assertions.assertEquals((int)1, (int)suspended.size());
            Assertions.assertEquals((Object)"transform", suspended.iterator().next());
        });
        mbeanServer.invoke(on, "step", null, null);
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Set suspended = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
            Assertions.assertNotNull((Object)suspended);
            Assertions.assertEquals((int)1, (int)suspended.size());
            Assertions.assertEquals((Object)"cheese", suspended.iterator().next());
        });
        mbeanServer.invoke(on, "step", null, null);
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Set suspended = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
            Assertions.assertNotNull((Object)suspended);
            Assertions.assertEquals((int)1, (int)suspended.size());
            Assertions.assertEquals((Object)"result", suspended.iterator().next());
        });
        mbeanServer.invoke(on, "step", null, null);
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Set suspended = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
            Assertions.assertNotNull((Object)suspended);
            Assertions.assertEquals((int)0, (int)suspended.size());
        });
        stepMode = (Boolean)mbeanServer.getAttribute(on, "SingleStepMode");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)stepMode, (String)"Should not be in step mode");
    }

    @Test
    public void testBacklogDebuggerStepCurrentNode() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=" + this.context.getManagementName() + ",type=tracer,name=BacklogDebugger");
        Assertions.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)enabled, (String)"Should not be enabled");
        mbeanServer.invoke(on, "enableDebugger", null, null);
        enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)enabled, (String)"Should be enabled");
        mbeanServer.invoke(on, "addBreakpoint", new Object[]{"foo"}, new String[]{"java.lang.String"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        mock.setSleepForEmptyTest(100L);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Set nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        Assertions.assertNotNull((Object)nodes);
        Assertions.assertEquals((int)1, (int)nodes.size());
        Assertions.assertEquals((Object)"foo", nodes.iterator().next());
        Boolean stepMode = (Boolean)mbeanServer.getAttribute(on, "SingleStepMode");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)stepMode, (String)"Should not be in step mode");
        mbeanServer.invoke(on, "stepBreakpoint", new Object[]{"foo"}, new String[]{"java.lang.String"});
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Set suspended = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
            Assertions.assertNotNull((Object)suspended);
            Assertions.assertEquals((int)1, (int)suspended.size());
            Assertions.assertEquals((Object)"bar", suspended.iterator().next());
        });
        mbeanServer.invoke(on, "stepBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Set suspended = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
            Assertions.assertNotNull((Object)suspended);
            Assertions.assertEquals((int)1, (int)suspended.size());
            Assertions.assertEquals((Object)"transform", suspended.iterator().next());
        });
        mbeanServer.invoke(on, "stepBreakpoint", new Object[]{"transform"}, new String[]{"java.lang.String"});
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Set suspended = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
            Assertions.assertNotNull((Object)suspended);
            Assertions.assertEquals((int)1, (int)suspended.size());
            Assertions.assertEquals((Object)"cheese", suspended.iterator().next());
        });
        mbeanServer.invoke(on, "stepBreakpoint", new Object[]{"cheese"}, new String[]{"java.lang.String"});
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Set suspended = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
            Assertions.assertNotNull((Object)suspended);
            Assertions.assertEquals((int)1, (int)suspended.size());
            Assertions.assertEquals((Object)"result", suspended.iterator().next());
        });
        mbeanServer.invoke(on, "stepBreakpoint", new Object[]{"result"}, new String[]{"java.lang.String"});
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Set suspended = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
            Assertions.assertNotNull((Object)suspended);
            Assertions.assertEquals((int)0, (int)suspended.size());
        });
        stepMode = (Boolean)mbeanServer.getAttribute(on, "SingleStepMode");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)stepMode, (String)"Should not be in step mode");
    }

    @Test
    public void testBacklogDebuggerExchangeProperties() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=" + this.context.getManagementName() + ",type=tracer,name=BacklogDebugger");
        Assertions.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)enabled, (String)"Should not be enabled");
        mbeanServer.invoke(on, "enableDebugger", null, null);
        enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)enabled, (String)"Should be enabled");
        mbeanServer.invoke(on, "addBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        mock.setSleepForEmptyTest(100L);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Set suspended = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
            Assertions.assertNotNull((Object)suspended);
            Assertions.assertEquals((int)1, (int)suspended.size());
            Assertions.assertEquals((Object)"bar", suspended.iterator().next());
        });
        String xml = (String)mbeanServer.invoke(on, "dumpTracedMessagesAsXml", new Object[]{"bar", true}, new String[]{"java.lang.String", "boolean"});
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        Assertions.assertTrue((boolean)xml.contains("<exchangeProperty name=\"myProperty\" type=\"java.lang.String\">myValue</exchangeProperty>"), (String)"Should contain myProperty");
        this.resetMocks();
        mock.expectedMessageCount(1);
        mbeanServer.invoke(on, "resumeBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        this.assertMockEndpointsSatisfied();
        Set nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        Assertions.assertNotNull((Object)nodes);
        Assertions.assertEquals((int)0, (int)nodes.size());
    }

    @Test
    public void testBacklogDebuggerEvaluateExpression() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=" + this.context.getManagementName() + ",type=tracer,name=BacklogDebugger");
        Assertions.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)enabled, (String)"Should not be enabled");
        mbeanServer.invoke(on, "enableDebugger", null, null);
        enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)enabled, (String)"Should be enabled");
        mbeanServer.invoke(on, "addBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        mock.setSleepForEmptyTest(100L);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Set suspended = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
            Assertions.assertNotNull((Object)suspended);
            Assertions.assertEquals((int)1, (int)suspended.size());
            Assertions.assertEquals((Object)"bar", suspended.iterator().next());
        });
        Object response = mbeanServer.invoke(on, "evaluateExpressionAtBreakpoint", new Object[]{"bar", "simple", "${body} contains 'Hello'", "java.lang.Boolean"}, new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"});
        Assertions.assertNotNull((Object)response);
        this.log.info(response.toString());
        Assertions.assertTrue((boolean)response.getClass().isAssignableFrom(Boolean.class));
        Assertions.assertTrue((boolean)((Boolean)response));
        response = mbeanServer.invoke(on, "evaluateExpressionAtBreakpoint", new Object[]{"bar", "simple", "${exchangeProperty.myProperty}", "java.lang.String"}, new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"});
        Assertions.assertNotNull((Object)response);
        this.log.info(response.toString());
        Assertions.assertTrue((boolean)response.getClass().isAssignableFrom(String.class));
        Assertions.assertEquals((Object)"myValue", (Object)response);
        response = mbeanServer.invoke(on, "evaluateExpressionAtBreakpoint", new Object[]{"bar", "simple", "${exchangeProperty.myProperty}"}, new String[]{"java.lang.String", "java.lang.String", "java.lang.String"});
        Assertions.assertNotNull((Object)response);
        this.log.info(response.toString());
        Assertions.assertTrue((boolean)response.getClass().isAssignableFrom(String.class));
        Assertions.assertEquals((Object)"myValue", (Object)response);
        this.resetMocks();
        mock.expectedMessageCount(1);
        mbeanServer.invoke(on, "resumeBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        this.assertMockEndpointsSatisfied();
        Set nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        Assertions.assertNotNull((Object)nodes);
        Assertions.assertEquals((int)0, (int)nodes.size());
    }

    @Test
    public void testBacklogDebuggerMessageHistory() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=" + this.context.getManagementName() + ",type=tracer,name=BacklogDebugger");
        Assertions.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)enabled, (String)"Should not be enabled");
        mbeanServer.invoke(on, "enableDebugger", null, null);
        enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)enabled, (String)"Should be enabled");
        mbeanServer.invoke(on, "addBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        mock.setSleepForEmptyTest(100L);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Set suspended = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
            Assertions.assertNotNull((Object)suspended);
            Assertions.assertEquals((int)1, (int)suspended.size());
            Assertions.assertEquals((Object)"bar", suspended.iterator().next());
        });
        Object response = mbeanServer.invoke(on, "messageHistoryOnBreakpointAsXml", new Object[]{"bar"}, new String[]{"java.lang.String"});
        Assertions.assertNotNull((Object)response);
        Assertions.assertTrue((boolean)response.getClass().isAssignableFrom(String.class));
        String history = (String)response;
        int count = history.split("messageHistoryEntry", -1).length - 1;
        Assertions.assertEquals((int)4, (int)count);
        Assertions.assertTrue((boolean)history.contains("processor=\"from[seda://start?concurrentConsumers=2]\""));
        Assertions.assertTrue((boolean)history.contains("routeId=\"route1\""));
        Assertions.assertTrue((boolean)history.contains("processorId=\"route1\""));
        Assertions.assertTrue((boolean)history.contains("location=\""));
        Assertions.assertTrue((boolean)history.contains("elapsed=\""));
        this.resetMocks();
        mock.expectedMessageCount(1);
        mbeanServer.invoke(on, "resumeBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        this.assertMockEndpointsSatisfied();
        Set nodes = (Set)mbeanServer.invoke(on, "getSuspendedBreakpointNodeIds", null, null);
        Assertions.assertNotNull((Object)nodes);
        Assertions.assertEquals((int)0, (int)nodes.size());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                BacklogDebuggerTest.this.context.setUseBreadcrumb(Boolean.valueOf(false));
                BacklogDebuggerTest.this.context.setDebugging(Boolean.valueOf(true));
                BacklogDebuggerTest.this.context.setMessageHistory(Boolean.valueOf(true));
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((ProcessorDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("seda:start?concurrentConsumers=2").setProperty("myProperty", (Expression)this.constant("myValue"))).id("setProp")).to("log:foo")).id("foo")).to("log:bar")).id("bar")).transform().constant((Object)"Bye World")).id("transform")).to("log:cheese?showExchangeId=true")).id("cheese")).to("mock:result")).id("result");
            }
        };
    }
}

