/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.time.Duration;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ThreadsDefinition;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedThreadPoolTest
extends ManagementTestSupport {
    @Test
    public void testManagedThreadPool() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("threadpools", "mythreads(threads)");
        Boolean shutdown = (Boolean)mbeanServer.getAttribute(on, "Shutdown");
        Assertions.assertEquals((Object)false, (Object)shutdown);
        Integer corePoolSize = (Integer)mbeanServer.getAttribute(on, "CorePoolSize");
        Assertions.assertEquals((int)15, (int)corePoolSize);
        Integer maxPoolSize = (Integer)mbeanServer.getAttribute(on, "MaximumPoolSize");
        Assertions.assertEquals((int)30, (int)maxPoolSize);
        Integer poolSize = (Integer)mbeanServer.getAttribute(on, "PoolSize");
        Assertions.assertEquals((int)0, (int)poolSize);
        Long keepAlive = (Long)mbeanServer.getAttribute(on, "KeepAliveTime");
        Assertions.assertEquals((int)60, (int)keepAlive.intValue());
        Boolean allow = (Boolean)mbeanServer.getAttribute(on, "AllowCoreThreadTimeout");
        Assertions.assertEquals((Object)true, (Object)allow);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Awaitility.await().atMost(Duration.ofSeconds(2L)).untilAsserted(() -> this.assertPoolSize(mbeanServer, on));
        Integer largest = (Integer)mbeanServer.getAttribute(on, "LargestPoolSize");
        Assertions.assertEquals((int)1, (int)largest);
        Long completed = (Long)mbeanServer.getAttribute(on, "CompletedTaskCount");
        Assertions.assertEquals((int)1, (int)completed.intValue());
        Long size = (Long)mbeanServer.getAttribute(on, "TaskQueueSize");
        Assertions.assertEquals((int)0, (int)size.intValue());
        Boolean empty = (Boolean)mbeanServer.getAttribute(on, "TaskQueueEmpty");
        Assertions.assertEquals((Object)true, (Object)empty);
        int remainingCapacity = (Integer)mbeanServer.invoke(on, "getTaskQueueRemainingCapacity", null, null);
        Assertions.assertEquals((int)200, (int)remainingCapacity, (String)"remainingCapacity");
    }

    private void assertPoolSize(MBeanServer mbeanServer, ObjectName on) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        Integer poolSize = (Integer)mbeanServer.getAttribute(on, "PoolSize");
        Assertions.assertEquals((int)1, (int)poolSize);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ThreadsDefinition)this.from("direct:start").threads(15, 30).id("mythreads")).maxQueueSize(200).to("mock:result");
            }
        };
    }
}

