/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.seda.SedaComponent;
import org.apache.camel.component.seda.SedaConsumer;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.impl.engine.DefaultSupervisingRouteController;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RouteController;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedSupervisingRouteControllerTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        DefaultSupervisingRouteController src = new DefaultSupervisingRouteController();
        src.setThreadPoolSize(2);
        src.setBackOffDelay(100L);
        src.setBackOffMaxAttempts(50L);
        context.setRouteController((RouteController)src);
        return context;
    }

    @Test
    public void testSupervisingRouteController() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("routecontrollers", "DefaultSupervisingRouteController");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on));
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertTrue((boolean)enabled);
        Integer threadPoolSize = (Integer)mbeanServer.getAttribute(on, "ThreadPoolSize");
        Assertions.assertEquals((int)2, (int)threadPoolSize);
        Long backOffDelay = (Long)mbeanServer.getAttribute(on, "BackOffDelay");
        Assertions.assertEquals((int)100, (int)backOffDelay.intValue());
        Integer routes = (Integer)mbeanServer.getAttribute(on, "NumberOfControlledRoutes");
        Assertions.assertEquals((int)3, (int)routes);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            Integer restarting = (Integer)mbeanServer.getAttribute(on, "NumberOfRestartingRoutes");
            Assertions.assertEquals((int)2, (int)restarting);
        });
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).untilAsserted(() -> {
            Integer exhausted = (Integer)mbeanServer.getAttribute(on, "NumberOfExhaustedRoutes");
            Assertions.assertEquals((int)2, (int)exhausted);
        });
        TabularData data = (TabularData)mbeanServer.invoke(on, "routeStatus", new Object[]{true, true, true}, new String[]{"boolean", "boolean", "boolean"});
        Assertions.assertNotNull((Object)data);
        Assertions.assertEquals((int)3, (int)data.size());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.getContext().addComponent("jms", (Component)new MyJmsComponent());
                ((RouteDefinition)this.from("timer:foo").to("mock:foo")).routeId("foo");
                ((RouteDefinition)this.from("jms:cheese").to("mock:cheese")).routeId("cheese");
                ((RouteDefinition)this.from("jms:cake").to("mock:cake")).routeId("cake");
                this.from("seda:bar").routeId("bar").noAutoStartup().to("mock:bar");
            }
        };
    }

    private class MyJmsConsumer
    extends SedaConsumer {
        public MyJmsConsumer(SedaEndpoint endpoint, Processor processor) {
            super(endpoint, processor);
        }

        protected void doStart() throws Exception {
            throw new IllegalArgumentException("Cannot start");
        }
    }

    private class MyJmsEndpoint
    extends SedaEndpoint {
        public Consumer createConsumer(Processor processor) throws Exception {
            return new MyJmsConsumer(this, processor);
        }

        protected String createEndpointUri() {
            return "jms:cheese";
        }
    }

    private class MyJmsComponent
    extends SedaComponent {
        private MyJmsComponent() {
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
            return new MyJmsEndpoint();
        }
    }
}

