/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedFromRestGetEmbeddedRouteTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getRegistry().bind("dummy-test", (Object)new DummyRestConsumerFactory());
        return context;
    }

    @Test
    public void testFromRestModel() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getContextObjectName();
        String xml = (String)mbeanServer.invoke(on, "dumpRestsAsXml", null, null);
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        Assertions.assertTrue((boolean)xml.contains("<rests"));
        Assertions.assertTrue((boolean)xml.contains("<rest path=\"/say/hello\">"));
        Assertions.assertTrue((boolean)xml.contains("<rest path=\"/say/bye\">"));
        Assertions.assertTrue((boolean)xml.contains("</rest>"));
        Assertions.assertTrue((boolean)xml.contains("<get"));
        Assertions.assertTrue((boolean)xml.contains("<route"));
        Assertions.assertTrue((boolean)xml.contains("<transform"));
        Assertions.assertTrue((boolean)xml.contains("<post"));
        Assertions.assertTrue((boolean)xml.contains("application/json"));
        Assertions.assertTrue((boolean)xml.contains("</rests>"));
        String xml2 = (String)mbeanServer.invoke(on, "dumpRoutesAsXml", null, null);
        this.log.info(xml2);
        Assertions.assertTrue((boolean)xml2.contains("rest=\"true\""));
        Assertions.assertEquals((int)3, (int)this.context.getRouteDefinitions().size());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.restConfiguration().host("localhost");
                ((RouteDefinition)this.rest("/say/hello").get().route().to("mock:hello")).transform((Expression)this.constant("Hello World"));
                ((RouteDefinition)((RouteDefinition)this.rest("/say/bye").get().consumes("application/json").route().to("mock:bye")).transform((Expression)this.constant("Bye World"))).endRest().post().to("mock:update");
            }
        };
    }
}

