/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.controlbus;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ControlBusStatsTest
extends ContextTestSupport {
    protected boolean useJmx() {
        return true;
    }

    @Test
    public void testControlBusRouteStat() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String xml = (String)this.template.requestBody("controlbus:route?routeId=foo&action=stats", null, String.class);
        Assertions.assertNotNull((Object)xml);
        Assertions.assertTrue((boolean)xml.contains("routeStat"));
        Assertions.assertTrue((boolean)xml.contains("processorStat"));
        Assertions.assertTrue((boolean)xml.contains("id=\"foo\""));
        Assertions.assertTrue((boolean)xml.contains("exchangesCompleted=\"1\""));
    }

    @Test
    public void testControlBusCurrentRouteStat() throws Exception {
        this.getMockEndpoint("mock:current").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:current", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String xml = (String)this.template.requestBody("controlbus:route?routeId=current&action=stats", null, String.class);
        Assertions.assertNotNull((Object)xml);
        Assertions.assertTrue((boolean)xml.contains("routeStat"));
        Assertions.assertTrue((boolean)xml.contains("processorStat"));
        Assertions.assertTrue((boolean)xml.contains("id=\"current\""));
        Assertions.assertTrue((boolean)xml.contains("exchangesCompleted=\"1\""));
    }

    @Test
    public void testControlBusContextStat() throws Exception {
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:bar", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String xml = (String)this.template.requestBody("controlbus:route?action=stats", null, String.class);
        Assertions.assertNotNull((Object)xml);
        Assertions.assertTrue((boolean)xml.contains("camelContextStat"));
        Assertions.assertTrue((boolean)xml.contains("routeStat"));
        Assertions.assertTrue((boolean)xml.contains("processorStat"));
        Assertions.assertTrue((boolean)xml.contains("id=\"bar\""));
        Assertions.assertTrue((boolean)xml.contains("id=\"foo\""));
        Assertions.assertTrue((boolean)xml.contains("exchangesCompleted=\"1\""));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:foo").routeId("foo").to("mock:foo");
                this.from("direct:bar").routeId("bar").to("mock:bar");
                this.from("direct:current").routeId("current").to("mock:current");
            }
        };
    }
}

