/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.support.RoutePolicySupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedRouteRestartTest
extends ManagementTestSupport {
    private MyRoutePolicy myRoutePolicy = new MyRoutePolicy();

    @Test
    public void testRestartRoute() throws Exception {
        Assertions.assertEquals((int)1, (int)this.myRoutePolicy.getStart());
        Assertions.assertEquals((int)0, (int)this.myRoutePolicy.getStop());
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        Assertions.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        boolean registered = mbeanServer.isRegistered(on);
        Assertions.assertEquals((Object)true, (Object)registered, (String)"Should be registered");
        String uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
        Assertions.assertEquals((Object)"direct://start", (Object)uri);
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state, (String)"Should be started");
        String uptime = (String)mbeanServer.getAttribute(on, "Uptime");
        Assertions.assertNotNull((Object)uptime);
        this.log.info("Uptime: {}", (Object)uptime);
        long uptimeMillis = (Long)mbeanServer.getAttribute(on, "UptimeMillis");
        Assertions.assertTrue((uptimeMillis > 0L ? 1 : 0) != 0);
        mbeanServer.invoke(on, "restart", null, null);
        registered = mbeanServer.isRegistered(on);
        Assertions.assertEquals((Object)true, (Object)registered, (String)"Should be registered");
        state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state, (String)"Should be started");
        Assertions.assertEquals((int)2, (int)this.myRoutePolicy.getStart());
        Assertions.assertEquals((int)1, (int)this.myRoutePolicy.getStop());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").routePolicy(new RoutePolicy[]{ManagedRouteRestartTest.this.myRoutePolicy}).delayer(10L).to("log:foo")).to("mock:result");
            }
        };
    }

    private final class MyRoutePolicy
    extends RoutePolicySupport {
        private int start;
        private int stop;

        private MyRoutePolicy() {
        }

        public void onStart(Route route) {
            ++this.start;
        }

        public void onStop(Route route) {
            ++this.stop;
        }

        public int getStart() {
            return this.start;
        }

        public int getStop() {
            return this.stop;
        }
    }
}

