/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.TestSupport;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.engine.DefaultCamelContextNameStrategy;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TwoManagedCamelContextAutoAssignedNameClashTest
extends TestSupport {
    private CamelContext camel1;
    private CamelContext camel2;

    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        return context;
    }

    @Test
    public void testTwoManagedCamelContextClash() throws Exception {
        this.camel1 = this.createCamelContext();
        this.camel1.start();
        Assertions.assertTrue((boolean)this.camel1.getStatus().isStarted(), (String)"Should be started");
        MBeanServer mbeanServer = this.camel1.getManagementStrategy().getManagementAgent().getMBeanServer();
        ObjectName on = TwoManagedCamelContextAutoAssignedNameClashTest.getContextObjectName(this.camel1);
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered");
        DefaultCamelContextNameStrategy.setCounter((int)0);
        this.camel2 = this.createCamelContext();
        this.camel2.start();
        ObjectName on2 = TwoManagedCamelContextAutoAssignedNameClashTest.getContextObjectName(this.camel2);
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on2), (String)"Should be registered");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should still be registered after name clash");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on2), (String)"Should still be registered after name clash");
    }

    private static ObjectName getContextObjectName(CamelContext context) throws MalformedObjectNameException {
        return ObjectName.getInstance("org.apache.camel:context=" + context.getManagementName() + ",type=context,name=\"" + context.getName() + "\"");
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.camel1 != null) {
            this.camel1.stop();
        }
        if (this.camel2 != null) {
            this.camel2.stop();
        }
        super.tearDown();
    }
}

