/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedSedaRouteRemoveTest
extends ManagementTestSupport {
    @Test
    public void testRemove() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedSedaRouteRemoveTest.getRouteObjectName(mbeanServer);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state, (String)"Should be started");
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=threadpools,*"), null);
        boolean seda = false;
        for (ObjectName names : set) {
            if (!names.toString().contains("Seda")) continue;
            seda = true;
            break;
        }
        Assertions.assertTrue((boolean)seda, (String)"There should be a seda thread pool");
        mbeanServer.invoke(on, "stop", null, null);
        state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Stopped.name(), (Object)state, (String)"Should be stopped");
        mbeanServer.invoke(on, "remove", null, null);
        boolean registered = mbeanServer.isRegistered(on);
        Assertions.assertFalse((boolean)registered, (String)"Route mbean should have been unregistered");
        set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        Assertions.assertEquals((int)0, (int)set.size());
        set = mbeanServer.queryNames(new ObjectName("*:type=threadpools,*"), null);
        seda = false;
        for (ObjectName names : set) {
            if (!names.toString().contains("Seda")) continue;
            seda = true;
            break;
        }
        Assertions.assertFalse((boolean)seda, (String)"There should not be a seda thread pool");
    }

    static ObjectName getRouteObjectName(MBeanServer mbeanServer) throws Exception {
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        Assertions.assertEquals((int)1, (int)set.size());
        return set.iterator().next();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:foo").to("mock:result");
            }
        };
    }
}

