/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.engine.ExplicitCamelContextNameStrategy;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.spi.CamelContextNameStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedCamelContextPropertiesTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementNameStrategy().setNamePattern("19-#name#");
        context.setNameStrategy((CamelContextNameStrategy)new ExplicitCamelContextNameStrategy("my-camel-context"));
        return context;
    }

    @Test
    public void testGetSetProperties() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getContextObjectName();
        Assertions.assertEquals((Object)"19-my-camel-context", (Object)this.context.getManagementName());
        Assertions.assertEquals((Object)"my-camel-context", (Object)this.context.getName());
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered");
        String name = (String)mbeanServer.getAttribute(on, "CamelId");
        Assertions.assertEquals((Object)"my-camel-context", (Object)name);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        mbeanServer.invoke(on, "setGlobalOption", new String[]{"CamelLogDebugBodyMaxChars", "-1"}, new String[]{"java.lang.String", "java.lang.String"});
        mbeanServer.invoke(on, "setGlobalOption", new String[]{"CamelLogDebugStreams", "true"}, new String[]{"java.lang.String", "java.lang.String"});
        Object invoke = mbeanServer.invoke(on, "getGlobalOption", new String[]{"CamelLogDebugBodyMaxChars"}, new String[]{"java.lang.String"});
        Assertions.assertEquals((Object)"-1", (Object)invoke);
        invoke = mbeanServer.invoke(on, "getGlobalOption", new String[]{"CamelLogDebugStreams"}, new String[]{"java.lang.String"});
        Assertions.assertEquals((Object)"true", (Object)invoke);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

