/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import org.apache.camel.management.mbean.LoadTriplet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LoadTripletTest {
    @Test
    public void testConstantUpdate() {
        LoadTriplet t = new LoadTriplet();
        t.update(1);
        Assertions.assertEquals((double)1.0, (double)t.getLoad1(), (double)(Math.ulp(1.0) * 5.0));
        Assertions.assertEquals((double)1.0, (double)t.getLoad5(), (double)(Math.ulp(1.0) * 5.0));
        Assertions.assertEquals((double)1.0, (double)t.getLoad15(), (double)(Math.ulp(1.0) * 5.0));
        for (int i = 0; i < 100; ++i) {
            t.update(1);
        }
        Assertions.assertEquals((double)1.0, (double)t.getLoad1(), (double)(Math.ulp(1.0) * 5.0));
        Assertions.assertEquals((double)1.0, (double)t.getLoad5(), (double)(Math.ulp(1.0) * 5.0));
        Assertions.assertEquals((double)1.0, (double)t.getLoad15(), (double)(Math.ulp(1.0) * 5.0));
    }

    @Test
    public void testChargeDischarge() {
        double diff;
        int i;
        LoadTriplet t = new LoadTriplet();
        t.update(0);
        double last = t.getLoad15();
        double lastDiff = Double.MAX_VALUE;
        for (i = 0; i < 1000; ++i) {
            t.update(5);
            diff = t.getLoad15() - last;
            Assertions.assertTrue((diff > 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((diff < lastDiff ? 1 : 0) != 0);
            lastDiff = diff;
            last = t.getLoad15();
        }
        lastDiff = -1.7976931348623157E308;
        for (i = 0; i < 1000; ++i) {
            t.update(0);
            diff = t.getLoad15() - last;
            Assertions.assertTrue((diff < 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((diff > lastDiff ? 1 : 0) != 0, (String)String.format("%f is smaller than %f", diff, lastDiff));
            lastDiff = diff;
            last = t.getLoad15();
        }
    }
}

