/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.List;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Exchange;
import org.apache.camel.api.management.mbean.BacklogTracerEventMessage;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class BacklogTracerTest
extends ManagementTestSupport {
    @Test
    public void testBacklogTracerEventMessage() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=" + this.context.getManagementName() + ",type=tracer,name=BacklogTracer");
        Assertions.assertNotNull((Object)on);
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on));
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)enabled, (String)"Should not be enabled");
        Integer size = (Integer)mbeanServer.getAttribute(on, "BacklogSize");
        Assertions.assertEquals((int)1000, (int)size, (String)"Should be 1000");
        Boolean removeOnDump = (Boolean)mbeanServer.getAttribute(on, "RemoveOnDump");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)removeOnDump);
        mbeanServer.setAttribute(on, new Attribute("Enabled", Boolean.TRUE));
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:bar").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        List exchanges = this.getMockEndpoint("mock:foo").getReceivedExchanges();
        List events = (List)mbeanServer.invoke(on, "dumpTracedMessages", new Object[]{"foo"}, new String[]{"java.lang.String"});
        Assertions.assertNotNull((Object)events);
        Assertions.assertEquals((int)2, (int)events.size());
        BacklogTracerEventMessage event1 = (BacklogTracerEventMessage)events.get(0);
        Assertions.assertEquals((Object)"foo", (Object)event1.getToNode());
        Assertions.assertEquals((Object)("    <message exchangeId=\"" + ((Exchange)exchanges.get(0)).getExchangeId() + "\">\n      <body type=\"java.lang.String\">Hello World</body>\n    </message>"), (Object)event1.getMessageAsXml());
        BacklogTracerEventMessage event2 = (BacklogTracerEventMessage)events.get(1);
        Assertions.assertEquals((Object)"foo", (Object)event2.getToNode());
        Assertions.assertEquals((Object)("    <message exchangeId=\"" + ((Exchange)exchanges.get(1)).getExchangeId() + "\">\n      <body type=\"java.lang.String\">Bye World</body>\n    </message>"), (Object)event2.getMessageAsXml());
    }

    @Test
    public void testBacklogTracerEventMessageAsXml() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=" + this.context.getManagementName() + ",type=tracer,name=BacklogTracer");
        Assertions.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)enabled, (String)"Should not be enabled");
        Integer size = (Integer)mbeanServer.getAttribute(on, "BacklogSize");
        Assertions.assertEquals((int)1000, (int)size, (String)"Should be 1000");
        mbeanServer.setAttribute(on, new Attribute("Enabled", Boolean.TRUE));
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:bar").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        String events = (String)mbeanServer.invoke(on, "dumpTracedMessagesAsXml", new Object[]{"foo"}, new String[]{"java.lang.String"});
        Assertions.assertNotNull((Object)events);
        this.log.info(events);
        Document dom = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)events);
        Assertions.assertNotNull((Object)dom);
        NodeList list = dom.getElementsByTagName("backlogTracerEventMessage");
        Assertions.assertEquals((int)2, (int)list.getLength());
    }

    @Test
    public void testBacklogTracerEventMessageDumpAll() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=" + this.context.getManagementName() + ",type=tracer,name=BacklogTracer");
        Assertions.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)enabled, (String)"Should not be enabled");
        mbeanServer.setAttribute(on, new Attribute("Enabled", Boolean.TRUE));
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:bar").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        List fooExchanges = this.getMockEndpoint("mock:foo").getReceivedExchanges();
        List barExchanges = this.getMockEndpoint("mock:bar").getReceivedExchanges();
        List events = (List)mbeanServer.invoke(on, "dumpAllTracedMessages", null, null);
        Assertions.assertNotNull((Object)events);
        Assertions.assertEquals((int)6, (int)events.size());
        BacklogTracerEventMessage event0 = (BacklogTracerEventMessage)events.get(0);
        Assertions.assertEquals((Object)"route1", (Object)event0.getRouteId());
        Assertions.assertEquals(null, (Object)event0.getToNode());
        Assertions.assertEquals((Object)("    <message exchangeId=\"" + ((Exchange)fooExchanges.get(0)).getExchangeId() + "\">\n      <body type=\"java.lang.String\">Hello World</body>\n    </message>"), (Object)event0.getMessageAsXml());
        BacklogTracerEventMessage event1 = (BacklogTracerEventMessage)events.get(1);
        Assertions.assertEquals((Object)"route1", (Object)event1.getRouteId());
        Assertions.assertEquals((Object)"foo", (Object)event1.getToNode());
        Assertions.assertEquals((Object)("    <message exchangeId=\"" + ((Exchange)fooExchanges.get(0)).getExchangeId() + "\">\n      <body type=\"java.lang.String\">Hello World</body>\n    </message>"), (Object)event1.getMessageAsXml());
        BacklogTracerEventMessage event2 = (BacklogTracerEventMessage)events.get(2);
        Assertions.assertEquals((Object)"route1", (Object)event2.getRouteId());
        Assertions.assertEquals((Object)"bar", (Object)event2.getToNode());
        Assertions.assertEquals((Object)("    <message exchangeId=\"" + ((Exchange)barExchanges.get(0)).getExchangeId() + "\">\n      <body type=\"java.lang.String\">Hello World</body>\n    </message>"), (Object)event2.getMessageAsXml());
        BacklogTracerEventMessage event3 = (BacklogTracerEventMessage)events.get(3);
        Assertions.assertEquals((Object)"route1", (Object)event3.getRouteId());
        Assertions.assertEquals(null, (Object)event3.getToNode());
        Assertions.assertEquals((Object)("    <message exchangeId=\"" + ((Exchange)fooExchanges.get(1)).getExchangeId() + "\">\n      <body type=\"java.lang.String\">Bye World</body>\n    </message>"), (Object)event3.getMessageAsXml());
        BacklogTracerEventMessage event4 = (BacklogTracerEventMessage)events.get(4);
        Assertions.assertEquals((Object)"route1", (Object)event4.getRouteId());
        Assertions.assertEquals((Object)"foo", (Object)event4.getToNode());
        Assertions.assertEquals((Object)("    <message exchangeId=\"" + ((Exchange)fooExchanges.get(1)).getExchangeId() + "\">\n      <body type=\"java.lang.String\">Bye World</body>\n    </message>"), (Object)event3.getMessageAsXml());
        BacklogTracerEventMessage event5 = (BacklogTracerEventMessage)events.get(5);
        Assertions.assertEquals((Object)"route1", (Object)event5.getRouteId());
        Assertions.assertEquals((Object)"bar", (Object)event5.getToNode());
        Assertions.assertEquals((Object)("    <message exchangeId=\"" + ((Exchange)barExchanges.get(1)).getExchangeId() + "\">\n      <body type=\"java.lang.String\">Bye World</body>\n    </message>"), (Object)event4.getMessageAsXml());
    }

    @Test
    public void testBacklogTracerEventMessageDumpAllAsXml() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=" + this.context.getManagementName() + ",type=tracer,name=BacklogTracer");
        Assertions.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)enabled, (String)"Should not be enabled");
        mbeanServer.setAttribute(on, new Attribute("Enabled", Boolean.TRUE));
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:bar").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        String events = (String)mbeanServer.invoke(on, "dumpAllTracedMessagesAsXml", null, null);
        Assertions.assertNotNull((Object)events);
        this.log.info(events);
        Document dom = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)events);
        Assertions.assertNotNull((Object)dom);
        NodeList list = dom.getElementsByTagName("backlogTracerEventMessage");
        Assertions.assertEquals((int)6, (int)list.getLength());
    }

    @Test
    public void testBacklogTracerNotRemoveOnDump() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=" + this.context.getManagementName() + ",type=tracer,name=BacklogTracer");
        Assertions.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean removeOnDump = (Boolean)mbeanServer.getAttribute(on, "RemoveOnDump");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)removeOnDump);
        mbeanServer.setAttribute(on, new Attribute("RemoveOnDump", Boolean.FALSE));
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)enabled, (String)"Should not be enabled");
        mbeanServer.setAttribute(on, new Attribute("Enabled", Boolean.TRUE));
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:bar").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        List events = (List)mbeanServer.invoke(on, "dumpAllTracedMessages", null, null);
        Assertions.assertNotNull((Object)events);
        Assertions.assertEquals((int)6, (int)events.size());
        events = (List)mbeanServer.invoke(on, "dumpAllTracedMessages", null, null);
        Assertions.assertNotNull((Object)events);
        Assertions.assertEquals((int)6, (int)events.size());
        this.resetMocks();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hi World");
        this.assertMockEndpointsSatisfied();
        events = (List)mbeanServer.invoke(on, "dumpAllTracedMessages", null, null);
        Assertions.assertNotNull((Object)events);
        Assertions.assertEquals((int)9, (int)events.size());
    }

    @Test
    public void testBacklogTracerNotRemoveOnDumpPattern() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=" + this.context.getManagementName() + ",type=tracer,name=BacklogTracer");
        Assertions.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean removeOnDump = (Boolean)mbeanServer.getAttribute(on, "RemoveOnDump");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)removeOnDump);
        mbeanServer.setAttribute(on, new Attribute("RemoveOnDump", Boolean.FALSE));
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)enabled, (String)"Should not be enabled");
        mbeanServer.setAttribute(on, new Attribute("Enabled", Boolean.TRUE));
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:bar").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        List events = (List)mbeanServer.invoke(on, "dumpTracedMessages", new Object[]{"foo"}, new String[]{"java.lang.String"});
        Assertions.assertNotNull((Object)events);
        Assertions.assertEquals((int)2, (int)events.size());
        events = (List)mbeanServer.invoke(on, "dumpTracedMessages", new Object[]{"foo"}, new String[]{"java.lang.String"});
        Assertions.assertEquals((int)2, (int)events.size());
        this.resetMocks();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hi World");
        this.assertMockEndpointsSatisfied();
        events = (List)mbeanServer.invoke(on, "dumpTracedMessages", new Object[]{"foo"}, new String[]{"java.lang.String"});
        Assertions.assertNotNull((Object)events);
        Assertions.assertEquals((int)3, (int)events.size());
        events = (List)mbeanServer.invoke(on, "dumpTracedMessages", new Object[]{"bar"}, new String[]{"java.lang.String"});
        Assertions.assertNotNull((Object)events);
        Assertions.assertEquals((int)3, (int)events.size());
    }

    @Test
    public void testBacklogTracerNotRemoveOverflow() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=" + this.context.getManagementName() + ",type=tracer,name=BacklogTracer");
        Assertions.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean removeOnDump = (Boolean)mbeanServer.getAttribute(on, "RemoveOnDump");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)removeOnDump);
        mbeanServer.setAttribute(on, new Attribute("RemoveOnDump", Boolean.FALSE));
        Integer size = (Integer)mbeanServer.getAttribute(on, "BacklogSize");
        Assertions.assertEquals((int)1000, (int)size, (String)"Should be 1000");
        mbeanServer.setAttribute(on, new Attribute("BacklogSize", 20));
        mbeanServer.setAttribute(on, new Attribute("TracePattern", "foo"));
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)enabled, (String)"Should not be enabled");
        mbeanServer.setAttribute(on, new Attribute("Enabled", Boolean.TRUE));
        this.getMockEndpoint("mock:foo").expectedMessageCount(10);
        this.getMockEndpoint("mock:bar").expectedMessageCount(10);
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("direct:start", (Object)("###" + i + "###"));
        }
        this.assertMockEndpointsSatisfied();
        List events = (List)mbeanServer.invoke(on, "dumpTracedMessages", new Object[]{"foo"}, new String[]{"java.lang.String"});
        Assertions.assertEquals((int)10, (int)events.size());
        String xml = ((BacklogTracerEventMessage)events.get(0)).getMessageAsXml();
        Assertions.assertTrue((boolean)xml.contains("###0###"));
        xml = ((BacklogTracerEventMessage)events.get(9)).getMessageAsXml();
        Assertions.assertTrue((boolean)xml.contains("###9###"));
        this.template.sendBody("direct:start", (Object)"###10###");
        events = (List)mbeanServer.invoke(on, "dumpTracedMessages", new Object[]{"foo"}, new String[]{"java.lang.String"});
        Assertions.assertEquals((int)10, (int)events.size());
        xml = ((BacklogTracerEventMessage)events.get(0)).getMessageAsXml();
        Assertions.assertTrue((boolean)xml.contains("###1###"));
        xml = ((BacklogTracerEventMessage)events.get(9)).getMessageAsXml();
        Assertions.assertTrue((boolean)xml.contains("###10###"));
        this.template.sendBody("direct:start", (Object)"###11###");
        this.template.sendBody("direct:start", (Object)"###12###");
        this.template.sendBody("direct:start", (Object)"###13###");
        this.template.sendBody("direct:start", (Object)"###14###");
        events = (List)mbeanServer.invoke(on, "dumpTracedMessages", new Object[]{"foo"}, new String[]{"java.lang.String"});
        Assertions.assertEquals((int)10, (int)events.size());
        xml = ((BacklogTracerEventMessage)events.get(0)).getMessageAsXml();
        Assertions.assertTrue((boolean)xml.contains("###5###"));
        xml = ((BacklogTracerEventMessage)events.get(9)).getMessageAsXml();
        Assertions.assertTrue((boolean)xml.contains("###14###"));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                BacklogTracerTest.this.context.setUseBreadcrumb(Boolean.valueOf(false));
                BacklogTracerTest.this.context.setBacklogTracing(Boolean.valueOf(true));
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:foo")).id("foo")).to("mock:bar")).id("bar");
            }
        };
    }
}

