/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.TestSupport;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TwoManagedNamePatternTest
extends TestSupport {
    private CamelContext camel1;
    private CamelContext camel2;

    protected CamelContext createCamelContext(String name, String pattern) throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.setName(name);
        context.getManagementNameStrategy().setNamePattern(pattern);
        return context;
    }

    @Test
    public void testManagedNamePattern() throws Exception {
        this.camel1 = this.createCamelContext("foo", "aaa-#name#");
        this.camel2 = this.createCamelContext("bar", "bbb-#name#");
        this.camel1.start();
        this.camel2.start();
        MBeanServer mbeanServer = this.camel1.getManagementStrategy().getManagementAgent().getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=aaa-foo,type=context,name=\"foo\"");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered");
        ObjectName on2 = ObjectName.getInstance("org.apache.camel:context=bbb-bar,type=context,name=\"bar\"");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on2), (String)"Should be registered");
        this.camel1.stop();
        this.camel2.stop();
        Assertions.assertFalse((boolean)mbeanServer.isRegistered(on), (String)"Should be unregistered");
        Assertions.assertFalse((boolean)mbeanServer.isRegistered(on2), (String)"Should be unregistered");
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.camel1 != null) {
            this.camel1.stop();
        }
        if (this.camel2 != null) {
            this.camel2.stop();
        }
        super.tearDown();
    }
}

