/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ThreadsDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedThreadPoolWithIdTest
extends ManagementTestSupport {
    @Test
    public void testManagedThreadPool() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("threadpools", "myThreads(threads)");
        Boolean shutdown = (Boolean)mbeanServer.getAttribute(on, "Shutdown");
        Assertions.assertEquals((Object)false, (Object)shutdown);
        Integer corePoolSize = (Integer)mbeanServer.getAttribute(on, "CorePoolSize");
        Assertions.assertEquals((int)15, (int)corePoolSize);
        Integer maxPoolSize = (Integer)mbeanServer.getAttribute(on, "MaximumPoolSize");
        Assertions.assertEquals((int)30, (int)maxPoolSize);
        Integer poolSize = (Integer)mbeanServer.getAttribute(on, "PoolSize");
        Assertions.assertEquals((int)0, (int)poolSize);
        Long keepAlive = (Long)mbeanServer.getAttribute(on, "KeepAliveTime");
        Assertions.assertEquals((int)60, (int)keepAlive.intValue());
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String id = (String)mbeanServer.getAttribute(on, "Id");
        Assertions.assertEquals((Object)"myThreads", (Object)id);
        String source = (String)mbeanServer.getAttribute(on, "SourceId");
        Assertions.assertEquals((Object)"threads", (Object)source);
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        Assertions.assertEquals((Object)"myRoute", (Object)routeId);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ThreadsDefinition)this.from("direct:start").routeId("myRoute").threads(15, 30).id("myThreads")).to("mock:result");
            }
        };
    }
}

