/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedStatisticsTest
extends ManagementTestSupport {
    @Test
    public void testManageStatistics() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        Assertions.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        Long completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        Assertions.assertEquals((long)0L, (long)completed);
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(5);
        this.template.sendBody("direct:start", (Object)"A");
        this.template.sendBody("direct:start", (Object)"B");
        this.template.sendBody("direct:start", (Object)"C");
        this.template.sendBody("direct:start", (Object)"D");
        this.template.sendBody("direct:start", (Object)"E");
        this.assertMockEndpointsSatisfied();
        completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        Assertions.assertEquals((long)5L, (long)completed);
        String first = (String)mbeanServer.getAttribute(on, "FirstExchangeCompletedExchangeId");
        Assertions.assertEquals((Object)((Exchange)result.getReceivedExchanges().get(0)).getExchangeId(), (Object)first);
        String firstFail = (String)mbeanServer.getAttribute(on, "FirstExchangeFailureExchangeId");
        Assertions.assertNull((Object)firstFail);
        String last = (String)mbeanServer.getAttribute(on, "LastExchangeCompletedExchangeId");
        Assertions.assertEquals((Object)((Exchange)result.getReceivedExchanges().get(4)).getExchangeId(), (Object)last);
        String lastFail = (String)mbeanServer.getAttribute(on, "LastExchangeFailureExchangeId");
        Assertions.assertNull((Object)lastFail);
        ObjectName foo = this.getCamelObjectName("processors", "foo");
        completed = (Long)mbeanServer.getAttribute(foo, "ExchangesCompleted");
        Assertions.assertEquals((long)5L, (long)completed);
        ObjectName mock = this.getCamelObjectName("processors", "mock");
        completed = (Long)mbeanServer.getAttribute(mock, "ExchangesCompleted");
        Assertions.assertEquals((long)5L, (long)completed);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("log:foo")).id("foo")).to("log:bar")).id("bar")).to("mock:result")).id("mock");
            }
        };
    }
}

