/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedProducerRouteAddRemoveRegisterAlwaysTest
extends ManagementTestSupport {
    private static final int SERVICES = 12;

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementStrategy().getManagementAgent().setRegisterAlways(Boolean.valueOf(true));
        return context;
    }

    @Test
    public void testRouteAddRemoteRouteWithRecipientList() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        result.assertIsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("services", "*");
        Set<ObjectName> names = mbeanServer.queryNames(on, null);
        Assertions.assertEquals((int)12, (int)names.size());
        ObjectName onP = this.getCamelObjectName("producers", "*");
        Set<ObjectName> namesP = mbeanServer.queryNames(onP, null);
        Assertions.assertEquals((int)3, (int)namesP.size());
        this.log.info("Adding 2nd route");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:bar").routeId("bar").recipientList((Expression)this.header("bar"));
            }
        });
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:bar", (Object)"Hello World", "bar", (Object)"mock:bar");
        bar.assertIsSatisfied();
        names = mbeanServer.queryNames(on, null);
        Assertions.assertEquals((int)12, (int)names.size());
        namesP = mbeanServer.queryNames(onP, null);
        Assertions.assertEquals((int)5, (int)namesP.size());
        this.log.info("Removing 2nd route");
        this.context.getRouteController().stopRoute("bar");
        boolean removed = this.context.removeRoute("bar");
        Assertions.assertTrue((boolean)removed);
        names = mbeanServer.queryNames(on, null);
        Assertions.assertEquals((int)12, (int)names.size());
        namesP = mbeanServer.queryNames(onP, null);
        Assertions.assertEquals((int)4, (int)namesP.size());
        this.log.info("Shutting down...");
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").routeId("foo").to("log:foo")).to("mock:result");
            }
        };
    }
}

