/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedEndpointUtilizationStatisticsTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext camelContext = super.createCamelContext();
        camelContext.getManagementStrategy().getManagementAgent().setStatisticsLevel(ManagementStatisticsLevel.Extended);
        return camelContext;
    }

    @Test
    public void testManageEndpointUtilizationStatistics() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(4);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.template.sendBody("seda:start", (Object)"Bye World");
        this.template.sendBody("seda:start", (Object)"Hi World");
        this.template.sendBody("seda:start", (Object)"Camel World");
        this.assertMockEndpointsSatisfied();
        List stats = this.context.getRuntimeEndpointRegistry().getEndpointStatistics();
        Assertions.assertNotNull((Object)stats);
        Assertions.assertEquals((int)2, (int)stats.size());
        Assertions.assertEquals((long)4L, (long)((RuntimeEndpointRegistry.Statistic)stats.get(0)).getHits());
        Assertions.assertEquals((long)4L, (long)((RuntimeEndpointRegistry.Statistic)stats.get(1)).getHits());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:start").to("mock:result");
            }
        };
    }
}

