/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedDelayerTest
extends ManagementTestSupport {
    @Test
    public void testManageDelay() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName delayerName = this.getCamelObjectName("processors", "mydelayer");
        ObjectName routeName = this.getCamelObjectName("routes", "route1");
        Long completed = (Long)mbeanServer.getAttribute(routeName, "ExchangesCompleted");
        Assertions.assertEquals((long)1L, (long)completed);
        Long last = (Long)mbeanServer.getAttribute(routeName, "LastProcessingTime");
        Long total = (Long)mbeanServer.getAttribute(routeName, "TotalProcessingTime");
        Assertions.assertTrue((last > 90L ? 1 : 0) != 0, (String)("Should take around 0.1 sec: was " + last));
        Assertions.assertTrue((total > 90L ? 1 : 0) != 0, (String)("Should take around 0.1 sec: was " + total));
        mbeanServer.invoke(delayerName, "constantDelay", new Object[]{200}, new String[]{"java.lang.Integer"});
        this.template.sendBody("direct:start", (Object)"Bye World");
        Long delay = (Long)mbeanServer.getAttribute(delayerName, "Delay");
        Assertions.assertNotNull((Object)delay);
        completed = (Long)mbeanServer.getAttribute(routeName, "ExchangesCompleted");
        Assertions.assertEquals((long)2L, (long)completed);
        last = (Long)mbeanServer.getAttribute(routeName, "LastProcessingTime");
        total = (Long)mbeanServer.getAttribute(routeName, "TotalProcessingTime");
        Assertions.assertTrue((last > 190L ? 1 : 0) != 0, (String)("Should take around 0.2 sec: was " + last));
        Assertions.assertTrue((total > 290L ? 1 : 0) != 0, (String)("Should be around 0.3 sec now: was " + total));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).delay(100L).id("mydelayer").to("mock:result");
            }
        };
    }
}

