/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedUnregisterCamelContextTest
extends ManagementTestSupport {
    @Test
    public void testUnregisterCamelContext() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getContextObjectName();
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered");
        String name = (String)mbeanServer.getAttribute(on, "CamelId");
        Assertions.assertEquals((Object)this.context.getName(), (Object)name);
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        String version = (String)mbeanServer.getAttribute(on, "CamelVersion");
        Assertions.assertNotNull((Object)version);
        Map properties = (Map)mbeanServer.getAttribute(on, "GlobalOptions");
        Assertions.assertNull((Object)properties);
        Long num = (Long)mbeanServer.getAttribute(on, "ExchangesInflight");
        Assertions.assertEquals((long)0L, (long)num);
        this.context.stop();
        Assertions.assertFalse((boolean)mbeanServer.isRegistered(on), (String)"Should no longer be registered");
    }
}

