/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedStatisticsWithSplitterTest
extends ManagementTestSupport {
    @Test
    public void testManageStatistics() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("routes", "route-a");
        Long completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        Assertions.assertEquals((long)0L, (long)completed);
        this.template.sendBody("direct:start", (Object)"A,B,C");
        this.template.sendBody("direct:start", (Object)"D,E");
        completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        Assertions.assertEquals((long)2L, (long)completed);
        ObjectName foo = this.getCamelObjectName("processors", "foo");
        completed = (Long)mbeanServer.getAttribute(foo, "ExchangesCompleted");
        Assertions.assertEquals((long)2L, (long)completed);
        ObjectName bar = this.getCamelObjectName("processors", "bar");
        completed = (Long)mbeanServer.getAttribute(bar, "ExchangesCompleted");
        Assertions.assertEquals((long)5L, (long)completed);
        ObjectName mock = this.getCamelObjectName("processors", "mock");
        completed = (Long)mbeanServer.getAttribute(mock, "ExchangesCompleted");
        Assertions.assertEquals((long)2L, (long)completed);
        on = this.getCamelObjectName("routes", "route-b");
        completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        Assertions.assertEquals((long)5L, (long)completed);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("route-a").to("log:foo")).id("foo")).split((Expression)this.body().tokenize(",")).to("direct:split")).end().to("mock:result").id("mock");
                ((RouteDefinition)this.from("direct:split").routeId("route-b").to("log:bar")).id("bar");
            }
        };
    }
}

