/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagedRouteDumpRouteAsXmlTest
extends ManagementTestSupport {
    @Test
    public void testDumpAsXml() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteDumpRouteAsXmlTest.getRouteObjectName(mbeanServer);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        Assertions.assertEquals((Object)"myRoute", (Object)routeId);
        String xml = (String)mbeanServer.invoke(on, "dumpRouteAsXml", null, null);
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        Assertions.assertTrue((boolean)xml.contains("route"));
        Assertions.assertTrue((boolean)xml.contains("myRoute"));
        Assertions.assertTrue((boolean)xml.contains("ref:bar"));
        Assertions.assertTrue((boolean)xml.contains("{{result}}"));
        Assertions.assertTrue((boolean)xml.contains("java.lang.Exception"));
    }

    @Test
    public void testDumpAsXmlResolvePlaceholder() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteDumpRouteAsXmlTest.getRouteObjectName(mbeanServer);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        Assertions.assertEquals((Object)"myRoute", (Object)routeId);
        String xml = (String)mbeanServer.invoke(on, "dumpRouteAsXml", new Object[]{true}, new String[]{"boolean"});
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        Assertions.assertTrue((boolean)xml.contains("route"));
        Assertions.assertTrue((boolean)xml.contains("myRoute"));
        Assertions.assertTrue((boolean)xml.contains("ref:bar"));
        Assertions.assertTrue((boolean)xml.contains("mock:result"));
        Assertions.assertTrue((boolean)xml.contains("java.lang.Exception"));
    }

    @Test
    public void testDumpAsXmlResolvePlaceholderDelegateEndpoint() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteDumpRouteAsXmlTest.getRouteObjectName(mbeanServer);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        Assertions.assertEquals((Object)"myRoute", (Object)routeId);
        String xml = (String)mbeanServer.invoke(on, "dumpRouteAsXml", new Object[]{true, true}, new String[]{"boolean", "boolean"});
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        Assertions.assertTrue((boolean)xml.contains("route"));
        Assertions.assertTrue((boolean)xml.contains("myRoute"));
        Assertions.assertTrue((boolean)xml.contains("mock://bar"));
        Assertions.assertTrue((boolean)xml.contains("mock:result"));
        Assertions.assertTrue((boolean)xml.contains("java.lang.Exception"));
    }

    static ObjectName getRouteObjectName(MBeanServer mbeanServer) throws Exception {
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        Assertions.assertEquals((int)1, (int)set.size());
        return set.iterator().next();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                Properties props = new Properties();
                props.put("result", "mock:result");
                ManagedRouteDumpRouteAsXmlTest.this.context.getPropertiesComponent().setOverrideProperties(props);
                Endpoint bar = ManagedRouteDumpRouteAsXmlTest.this.context.getEndpoint("mock:bar");
                this.bindToRegistry("bar", bar);
                ((OnExceptionDefinition)this.onException(Exception.class).log("${exception.stacktrace}")).logStackTrace(true).handled(true);
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("myRoute").log("Got ${body}")).to("ref:bar")).to("{{result}}");
            }
        };
    }
}

