/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class ManagedUnregisterProcessorTest
extends ManagementTestSupport {
    @Test
    public void testUnregisterProcessor() throws Exception {
        if (ManagedUnregisterProcessorTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), null);
        ManagedUnregisterProcessorTest.assertEquals((long)2L, (long)set.size());
        ObjectName on = set.iterator().next();
        ManagedUnregisterProcessorTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        String id = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedUnregisterProcessorTest.assertEquals((Object)"camel-1", (Object)id);
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedUnregisterProcessorTest.assertEquals((Object)"route1", (Object)routeId);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").setHeader("foo", (Expression)this.constant("bar"))).to("mock:result");
            }
        };
    }
}

