/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.Test;

public class ManagedUnregisterComponentTest
extends ManagementTestSupport {
    @Test
    public void testUnregisterComponent() throws Exception {
        if (ManagedUnregisterComponentTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=components,*"), null);
        ManagedUnregisterComponentTest.assertEquals((long)2L, (long)set.size());
        ObjectName on = set.iterator().next();
        ManagedUnregisterComponentTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedUnregisterComponentTest.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        String id = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedUnregisterComponentTest.assertEquals((Object)"camel-1", (Object)id);
        this.context.stop();
        ManagedUnregisterComponentTest.assertFalse((String)"Should no longer be registered", (boolean)mbeanServer.isRegistered(on));
        set = mbeanServer.queryNames(new ObjectName("*:type=components,*"), null);
        ManagedUnregisterComponentTest.assertEquals((String)"Should no longer be registered", (long)0L, (long)set.size());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

