/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.Test;

public class ManagedUnregisterCamelContextTest
extends ManagementTestSupport {
    @Test
    public void testUnregisterCamelContext() throws Exception {
        if (ManagedUnregisterCamelContextTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=context,name=\"camel-1\"");
        ManagedUnregisterCamelContextTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        String name = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedUnregisterCamelContextTest.assertEquals((Object)"camel-1", (Object)name);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedUnregisterCamelContextTest.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        String version = (String)mbeanServer.getAttribute(on, "CamelVersion");
        ManagedUnregisterCamelContextTest.assertNotNull((Object)version);
        Map properties = (Map)mbeanServer.getAttribute(on, "GlobalOptions");
        ManagedUnregisterCamelContextTest.assertNull((Object)properties);
        Long num = (Long)mbeanServer.getAttribute(on, "ExchangesInflight");
        ManagedUnregisterCamelContextTest.assertEquals((long)0L, (long)num);
        this.context.stop();
        ManagedUnregisterCamelContextTest.assertFalse((String)"Should no longer be registered", (boolean)mbeanServer.isRegistered(on));
    }
}

