/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class ManagedTypeConverterRegistryTest
extends ManagementTestSupport {
    @Test
    public void testTypeConverterRegistry() throws Exception {
        if (ManagedTypeConverterRegistryTest.isPlatform((String)"aix")) {
            return;
        }
        this.getMockEndpoint("mock:a").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"3");
        this.template.sendBody("direct:start", (Object)"7");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=services,*");
        Set<ObjectName> names = mbeanServer.queryNames(on, null);
        ObjectName name = null;
        for (ObjectName service : names) {
            if (!service.toString().contains("DefaultTypeConverter")) continue;
            name = service;
            break;
        }
        ManagedTypeConverterRegistryTest.assertNotNull((String)"Cannot find DefaultTypeConverter", name);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(name, "StatisticsEnabled");
        ManagedTypeConverterRegistryTest.assertEquals((Object)Boolean.FALSE, (Object)enabled);
        mbeanServer.setAttribute(name, new Attribute("StatisticsEnabled", Boolean.TRUE));
        Long failed = (Long)mbeanServer.getAttribute(name, "FailedCounter");
        ManagedTypeConverterRegistryTest.assertEquals((long)0L, (long)failed.intValue());
        Long miss = (Long)mbeanServer.getAttribute(name, "MissCounter");
        ManagedTypeConverterRegistryTest.assertEquals((long)0L, (long)miss.intValue());
        mbeanServer.invoke(name, "resetTypeConversionCounters", null, null);
        this.template.sendBody("direct:start", (Object)"5");
        Long hit = (Long)mbeanServer.getAttribute(name, "HitCounter");
        ManagedTypeConverterRegistryTest.assertEquals((long)1L, (long)hit.intValue());
        failed = (Long)mbeanServer.getAttribute(name, "FailedCounter");
        ManagedTypeConverterRegistryTest.assertEquals((long)0L, (long)failed.intValue());
        miss = (Long)mbeanServer.getAttribute(name, "MissCounter");
        ManagedTypeConverterRegistryTest.assertEquals((long)0L, (long)miss.intValue());
        mbeanServer.invoke(name, "resetTypeConversionCounters", null, null);
        try {
            this.template.sendBody("direct:start", (Object)"foo");
            ManagedTypeConverterRegistryTest.fail((String)"Should have thrown exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        failed = (Long)mbeanServer.getAttribute(name, "FailedCounter");
        ManagedTypeConverterRegistryTest.assertEquals((long)1L, (long)failed.intValue());
        miss = (Long)mbeanServer.getAttribute(name, "MissCounter");
        ManagedTypeConverterRegistryTest.assertEquals((long)0L, (long)miss.intValue());
        mbeanServer.invoke(name, "resetTypeConversionCounters", null, null);
        failed = (Long)mbeanServer.getAttribute(name, "FailedCounter");
        ManagedTypeConverterRegistryTest.assertEquals((long)0L, (long)failed.intValue());
        miss = (Long)mbeanServer.getAttribute(name, "MissCounter");
        ManagedTypeConverterRegistryTest.assertEquals((long)0L, (long)miss.intValue());
        Integer converters = (Integer)mbeanServer.getAttribute(name, "NumberOfTypeConverters");
        ManagedTypeConverterRegistryTest.assertTrue((String)("Should be more than 150 converters, was: " + converters), (converters >= 150 ? 1 : 0) != 0);
        Boolean has = (Boolean)mbeanServer.invoke(name, "hasTypeConverter", new Object[]{"String", "java.io.InputStream"}, new String[]{"java.lang.String", "java.lang.String"});
        ManagedTypeConverterRegistryTest.assertTrue((String)"Should have type converter", (boolean)has);
        has = (Boolean)mbeanServer.invoke(name, "hasTypeConverter", new Object[]{"java.math.BigInteger", "int"}, new String[]{"java.lang.String", "java.lang.String"});
        ManagedTypeConverterRegistryTest.assertFalse((String)"Should not have type converter", (boolean)has);
        TabularData data = (TabularData)mbeanServer.invoke(name, "listTypeConverters", null, null);
        ManagedTypeConverterRegistryTest.assertTrue((String)("Should be more than 150 converters, was: " + data.size()), (data.size() >= 150 ? 1 : 0) != 0);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").routeId("foo").convertBodyTo(Integer.TYPE)).to("mock:a");
            }
        };
    }
}

