/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.camel.Message;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Transformer;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedTransformerRegistryTest
extends ManagementTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedTransformerRegistryTest.class);

    @Test
    public void testManageTransformerRegistry() throws Exception {
        if (ManagedTransformerRegistryTest.isPlatform((String)"aix")) {
            return;
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=services,*"), null);
        ArrayList<ObjectName> list = new ArrayList<ObjectName>(set);
        ObjectName on = null;
        for (ObjectName name : list) {
            if (!name.getCanonicalName().contains("DefaultTransformerRegistry")) continue;
            on = name;
            break;
        }
        ManagedTransformerRegistryTest.assertNotNull((String)"Should have found TransformerRegistry", on);
        Integer max = (Integer)mbeanServer.getAttribute(on, "MaximumCacheSize");
        ManagedTransformerRegistryTest.assertEquals((long)1000L, (long)max.intValue());
        Integer current = (Integer)mbeanServer.getAttribute(on, "Size");
        ManagedTransformerRegistryTest.assertEquals((long)2L, (long)current.intValue());
        current = (Integer)mbeanServer.getAttribute(on, "StaticSize");
        ManagedTransformerRegistryTest.assertEquals((long)0L, (long)current.intValue());
        current = (Integer)mbeanServer.getAttribute(on, "DynamicSize");
        ManagedTransformerRegistryTest.assertEquals((long)2L, (long)current.intValue());
        String source = (String)mbeanServer.getAttribute(on, "Source");
        ManagedTransformerRegistryTest.assertTrue((boolean)source.startsWith("TransformerRegistry"));
        ManagedTransformerRegistryTest.assertTrue((boolean)source.endsWith("capacity: 1000"));
        TabularData data = (TabularData)mbeanServer.invoke(on, "listTransformers", null, null);
        for (Object row : data.values()) {
            CompositeData composite = (CompositeData)row;
            String scheme = (String)composite.get("scheme");
            String from = (String)composite.get("from");
            String to = (String)composite.get("to");
            String description = (String)composite.get("description");
            boolean isStatic = (Boolean)composite.get("static");
            boolean isDynamic = (Boolean)composite.get("dynamic");
            LOG.info("[{}][{}][{}][{}][{}][{}]", new Object[]{scheme, from, to, isStatic, isDynamic, description});
            if (description.startsWith("ProcessorTransformer")) {
                ManagedTransformerRegistryTest.assertEquals(null, (Object)scheme);
                ManagedTransformerRegistryTest.assertEquals((Object)"xml:foo", (Object)from);
                ManagedTransformerRegistryTest.assertEquals((Object)"json:bar", (Object)to);
                continue;
            }
            if (description.startsWith("DataFormatTransformer")) {
                ManagedTransformerRegistryTest.assertEquals(null, (Object)scheme);
                ManagedTransformerRegistryTest.assertEquals((Object)("java:" + ManagedTransformerRegistryTest.class.getName()), (Object)from);
                ManagedTransformerRegistryTest.assertEquals((Object)"xml:test", (Object)to);
                continue;
            }
            if (description.startsWith("MyTransformer")) {
                ManagedTransformerRegistryTest.assertEquals((Object)"custom", (Object)scheme);
                ManagedTransformerRegistryTest.assertEquals(null, (Object)from);
                ManagedTransformerRegistryTest.assertEquals(null, (Object)to);
                continue;
            }
            ManagedTransformerRegistryTest.fail((String)("Unexpected transformer:" + description));
        }
        ManagedTransformerRegistryTest.assertEquals((long)2L, (long)data.size());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.transformer().fromType("xml:foo").toType("json:bar").withUri("direct:transformer");
                this.transformer().scheme("custom").withJava(MyTransformer.class);
                this.from("direct:start").to("mock:result");
            }
        };
    }

    public static class MyTransformer
    extends Transformer {
        public void transform(Message message, DataType from, DataType to) throws Exception {
        }
    }
}

