/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class ManagedTracerTest
extends ManagementTestSupport {
    @Test
    public void testDefaultTracer() throws Exception {
        if (ManagedTracerTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=camel-1,type=tracer,name=DefaultTracer");
        ManagedTracerTest.assertNotNull((Object)on);
        ManagedTracerTest.assertTrue((boolean)mbeanServer.isRegistered(on));
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        ManagedTracerTest.assertEquals((String)"Should be enabled", (Object)Boolean.TRUE, (Object)enabled);
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:bar").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Long count = (Long)mbeanServer.getAttribute(on, "TraceCounter");
        ManagedTracerTest.assertEquals((long)4L, (long)count.intValue());
    }

    @Test
    public void testDefaultTracerPattern() throws Exception {
        if (ManagedTracerTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=camel-1,type=tracer,name=DefaultTracer");
        ManagedTracerTest.assertNotNull((Object)on);
        ManagedTracerTest.assertTrue((boolean)mbeanServer.isRegistered(on));
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        ManagedTracerTest.assertEquals((String)"Should be enabled", (Object)Boolean.TRUE, (Object)enabled);
        mbeanServer.setAttribute(on, new Attribute("TracePattern", "foo*"));
        mbeanServer.invoke(on, "resetTraceCounter", null, null);
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:bar").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Long count = (Long)mbeanServer.getAttribute(on, "TraceCounter");
        ManagedTracerTest.assertEquals((long)2L, (long)count.intValue());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ManagedTracerTest.this.context.setUseBreadcrumb(Boolean.valueOf(false));
                ManagedTracerTest.this.context.setTracing(Boolean.valueOf(true));
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:foo")).id("foo")).to("mock:bar")).id("bar");
            }
        };
    }
}

