/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ServiceStatus;
import org.apache.camel.api.management.mbean.ManagedThrottlingExceptionRoutePolicyMBean;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.throttling.ThrottlingExceptionHalfOpenHandler;
import org.apache.camel.throttling.ThrottlingExceptionRoutePolicy;
import org.junit.Test;

public class ManagedThrottlingExceptionRoutePolicyTest
extends ManagementTestSupport {
    @Test
    public void testRoutes() throws Exception {
        if (ManagedThrottlingExceptionRoutePolicyTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedThrottlingExceptionRoutePolicyTest.assertEquals((long)1L, (long)set.size());
        ObjectName on = set.iterator().next();
        boolean registered = mbeanServer.isRegistered(on);
        ManagedThrottlingExceptionRoutePolicyTest.assertEquals((String)"Should be registered", (Object)true, (Object)registered);
        String uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
        ManagedThrottlingExceptionRoutePolicyTest.assertEquals((Object)"direct://start", (Object)uri);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedThrottlingExceptionRoutePolicyTest.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        String policy = (String)mbeanServer.getAttribute(on, "RoutePolicyList");
        ManagedThrottlingExceptionRoutePolicyTest.assertNotNull((Object)policy);
        ManagedThrottlingExceptionRoutePolicyTest.assertTrue((boolean)policy.startsWith("ThrottlingExceptionRoutePolicy"));
        String mbeanName = String.format("org.apache.camel:context=camel-1,name=%s,type=services", policy);
        set = mbeanServer.queryNames(new ObjectName(mbeanName), null);
        ManagedThrottlingExceptionRoutePolicyTest.assertEquals((long)1L, (long)set.size());
        on = set.iterator().next();
        ManagedThrottlingExceptionRoutePolicyTest.assertTrue((boolean)mbeanServer.isRegistered(on));
        String myType = (String)mbeanServer.getAttribute(on, "ServiceType");
        ManagedThrottlingExceptionRoutePolicyTest.assertEquals((Object)"ThrottlingExceptionRoutePolicy", (Object)myType);
        ManagedThrottlingExceptionRoutePolicyMBean proxy = JMX.newMBeanProxy(mbeanServer, on, ManagedThrottlingExceptionRoutePolicyMBean.class);
        ManagedThrottlingExceptionRoutePolicyTest.assertNotNull((Object)proxy);
        String myState = proxy.currentState();
        ManagedThrottlingExceptionRoutePolicyTest.assertEquals((Object)"State closed, failures 0", (Object)myState);
        Integer val = proxy.getCurrentFailures();
        ManagedThrottlingExceptionRoutePolicyTest.assertEquals((long)0L, (long)val.intValue());
        Long lastFail = proxy.getLastFailure();
        ManagedThrottlingExceptionRoutePolicyTest.assertEquals((long)0L, (long)lastFail);
        Long openAt = proxy.getOpenAt();
        ManagedThrottlingExceptionRoutePolicyTest.assertEquals((long)0L, (long)openAt);
        String handlerClass = proxy.getHalfOpenHandlerName();
        ManagedThrottlingExceptionRoutePolicyTest.assertEquals((Object)"DummyHandler", (Object)handlerClass);
        Integer threshold = proxy.getFailureThreshold();
        ManagedThrottlingExceptionRoutePolicyTest.assertEquals((long)10L, (long)threshold.intValue());
        Long window = proxy.getFailureWindow();
        ManagedThrottlingExceptionRoutePolicyTest.assertEquals((long)1000L, (long)window);
        Long halfOpenAfter = proxy.getHalfOpenAfter();
        ManagedThrottlingExceptionRoutePolicyTest.assertEquals((long)5000L, (long)halfOpenAfter);
        proxy.setHalfOpenAfter(Long.valueOf(10000L));
        halfOpenAfter = proxy.getHalfOpenAfter();
        ManagedThrottlingExceptionRoutePolicyTest.assertEquals((long)10000L, (long)halfOpenAfter);
        try {
            this.getMockEndpoint("mock:result").expectedMessageCount(0);
            this.template.sendBody("direct:start", (Object)"Hello World");
            this.assertMockEndpointsSatisfied();
        }
        catch (Exception exception) {
            // empty catch block
        }
        myState = proxy.currentState();
        ManagedThrottlingExceptionRoutePolicyTest.assertTrue((boolean)myState.contains("State closed, failures 1, last failure"));
        val = proxy.getCurrentFailures();
        ManagedThrottlingExceptionRoutePolicyTest.assertEquals((long)1L, (long)val.intValue());
        Thread.sleep(200L);
        lastFail = proxy.getLastFailure();
        ManagedThrottlingExceptionRoutePolicyTest.assertTrue((lastFail > 0L ? 1 : 0) != 0);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        final ThrottlingExceptionRoutePolicy policy = new ThrottlingExceptionRoutePolicy(10, 1000L, 5000L, null);
        policy.setHalfOpenHandler((ThrottlingExceptionHalfOpenHandler)new DummyHandler());
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("testRoute").routePolicy(new RoutePolicy[]{policy}).to("log:foo")).process((Processor)new BoomProcess())).to("mock:result");
            }
        };
    }

    class DummyHandler
    implements ThrottlingExceptionHalfOpenHandler {
        DummyHandler() {
        }

        public boolean isReadyToBeClosed() {
            return false;
        }
    }

    class BoomProcess
    implements Processor {
        BoomProcess() {
        }

        public void process(Exchange exchange) throws Exception {
            Thread.sleep(50L);
            throw new RuntimeException("boom!");
        }
    }
}

