/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ThreadsDefinition;
import org.junit.Test;

public class ManagedThreadsTest
extends ManagementTestSupport {
    @Test
    public void testManageThreads() throws Exception {
        if (ManagedThreadsTest.isPlatform((String)"aix")) {
            return;
        }
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"123");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedThreadsTest.assertEquals((Object)"route1", (Object)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedThreadsTest.assertEquals((Object)"camel-1", (Object)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedThreadsTest.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ThreadsDefinition)this.from("direct:start").threads(1, 2).id("mysend")).to("mock:foo");
            }
        };
    }
}

