/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy;
import org.junit.Test;

public class ManagedThreadPoolProfileTest
extends ManagementTestSupport {
    @Test
    public void testManagedThreadPool() throws Exception {
        if (ManagedThreadPoolProfileTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=threadpools,name=\"threads1(threads)\"");
        Boolean shutdown = (Boolean)mbeanServer.getAttribute(on, "Shutdown");
        ManagedThreadPoolProfileTest.assertEquals((Object)false, (Object)shutdown);
        Integer corePoolSize = (Integer)mbeanServer.getAttribute(on, "CorePoolSize");
        ManagedThreadPoolProfileTest.assertEquals((long)5L, (long)corePoolSize.intValue());
        Integer maxPoolSize = (Integer)mbeanServer.getAttribute(on, "MaximumPoolSize");
        ManagedThreadPoolProfileTest.assertEquals((long)15L, (long)maxPoolSize.intValue());
        Integer poolSize = (Integer)mbeanServer.getAttribute(on, "PoolSize");
        ManagedThreadPoolProfileTest.assertEquals((long)0L, (long)poolSize.intValue());
        Long keepAlive = (Long)mbeanServer.getAttribute(on, "KeepAliveTime");
        ManagedThreadPoolProfileTest.assertEquals((long)25L, (long)keepAlive.intValue());
        Boolean allow = (Boolean)mbeanServer.getAttribute(on, "AllowCoreThreadTimeout");
        ManagedThreadPoolProfileTest.assertEquals((Object)true, (Object)allow);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String id = (String)mbeanServer.getAttribute(on, "Id");
        ManagedThreadPoolProfileTest.assertEquals((Object)"threads1", (Object)id);
        String source = (String)mbeanServer.getAttribute(on, "SourceId");
        ManagedThreadPoolProfileTest.assertEquals((Object)"threads", (Object)source);
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedThreadPoolProfileTest.assertEquals((Object)"route1", (Object)routeId);
        String profileId = (String)mbeanServer.getAttribute(on, "ThreadPoolProfileId");
        ManagedThreadPoolProfileTest.assertEquals((Object)"custom", (Object)profileId);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ThreadPoolProfile profile = new ThreadPoolProfile("custom");
                profile.setPoolSize(Integer.valueOf(5));
                profile.setMaxPoolSize(Integer.valueOf(15));
                profile.setKeepAliveTime(Long.valueOf(25L));
                profile.setMaxQueueSize(Integer.valueOf(250));
                profile.setAllowCoreThreadTimeOut(Boolean.valueOf(true));
                profile.setRejectedPolicy(ThreadPoolRejectedPolicy.Abort);
                ManagedThreadPoolProfileTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(profile);
                this.from("direct:start").threads().executorServiceRef("custom").to("mock:result");
            }
        };
    }
}

