/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.Test;

public class ManagedStatisticsDisabledTest
extends ManagementTestSupport {
    @Test
    public void testManageStatisticsDisabled() throws Exception {
        if (ManagedStatisticsDisabledTest.isPlatform((String)"aix")) {
            return;
        }
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedStatisticsDisabledTest.assertEquals((long)1L, (long)set.size());
        ObjectName on = set.iterator().next();
        Long completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        ManagedStatisticsDisabledTest.assertEquals((long)2L, (long)completed);
        mbeanServer.setAttribute(on, new Attribute("StatisticsEnabled", false));
        this.template.sendBody("direct:start", (Object)"Goodday World");
        completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        ManagedStatisticsDisabledTest.assertEquals((long)2L, (long)completed);
        mbeanServer.setAttribute(on, new Attribute("StatisticsEnabled", true));
        this.template.sendBody("direct:start", (Object)"Hi World");
        completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        ManagedStatisticsDisabledTest.assertEquals((long)3L, (long)completed);
        mbeanServer.invoke(on, "reset", null, null);
        this.template.sendBody("direct:start", (Object)"Hallo World");
        completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        ManagedStatisticsDisabledTest.assertEquals((long)1L, (long)completed);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

