/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class ManagedRouteUpdateRouteFromXmlTest
extends ManagementTestSupport {
    @Test
    public void testUpdateRouteFromXml() throws Exception {
        if (ManagedRouteUpdateRouteFromXmlTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteUpdateRouteFromXmlTest.getRouteObjectName(mbeanServer);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedRouteUpdateRouteFromXmlTest.assertEquals((Object)"myRoute", (Object)routeId);
        String xml = "<route id=\"myRoute\" xmlns=\"http://camel.apache.org/schema/spring\">  <from uri=\"direct:start\"/>  <log message=\"This is a changed route saying ${body}\"/>  <to uri=\"mock:changed\"/></route>";
        mbeanServer.invoke(on, "updateRouteFromXml", new Object[]{xml}, new String[]{"java.lang.String"});
        ManagedRouteUpdateRouteFromXmlTest.assertEquals((long)1L, (long)this.context.getRoutes().size());
        this.getMockEndpoint("mock:changed").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testUpdateRouteFromXmlWithoutRouteId() throws Exception {
        if (ManagedRouteUpdateRouteFromXmlTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteUpdateRouteFromXmlTest.getRouteObjectName(mbeanServer);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedRouteUpdateRouteFromXmlTest.assertEquals((Object)"myRoute", (Object)routeId);
        String xml = "<route xmlns=\"http://camel.apache.org/schema/spring\">  <from uri=\"direct:start\"/>  <log message=\"This is a changed route saying ${body}\"/>  <to uri=\"mock:changed\"/></route>";
        mbeanServer.invoke(on, "updateRouteFromXml", new Object[]{xml}, new String[]{"java.lang.String"});
        ManagedRouteUpdateRouteFromXmlTest.assertEquals((long)1L, (long)this.context.getRoutes().size());
        this.getMockEndpoint("mock:changed").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testUpdateRouteFromXmlMismatchRouteId() throws Exception {
        if (ManagedRouteUpdateRouteFromXmlTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteUpdateRouteFromXmlTest.getRouteObjectName(mbeanServer);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedRouteUpdateRouteFromXmlTest.assertEquals((Object)"myRoute", (Object)routeId);
        String xml = "<route id=\"foo\" xmlns=\"http://camel.apache.org/schema/spring\">  <from uri=\"direct:start\"/>  <log message=\"This is a changed route saying ${body}\"/>  <to uri=\"mock:changed\"/></route>";
        try {
            mbeanServer.invoke(on, "updateRouteFromXml", new Object[]{xml}, new String[]{"java.lang.String"});
            ManagedRouteUpdateRouteFromXmlTest.fail((String)"Should have thrown exception");
        }
        catch (Exception e) {
            ManagedRouteUpdateRouteFromXmlTest.assertIsInstanceOf(IllegalArgumentException.class, (Object)e.getCause());
            ManagedRouteUpdateRouteFromXmlTest.assertEquals((Object)"Cannot update route from XML as routeIds does not match. routeId: myRoute, routeId from XML: foo", (Object)e.getCause().getMessage());
        }
    }

    static ObjectName getRouteObjectName(MBeanServer mbeanServer) throws Exception {
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedRouteUpdateRouteFromXmlTest.assertEquals((long)1L, (long)set.size());
        return set.iterator().next();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").routeId("myRoute").log("Got ${body}")).to("mock:result");
            }
        };
    }
}

