/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class ManagedRouteStopTest
extends ManagementTestSupport {
    @Test
    public void testStopRoute() throws Exception {
        if (ManagedRouteStopTest.isPlatform((String)"aix")) {
            return;
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedRouteStopTest.assertEquals((long)1L, (long)set.size());
        ObjectName on = set.iterator().next();
        boolean registered = mbeanServer.isRegistered(on);
        ManagedRouteStopTest.assertEquals((String)"Should be registered", (Object)true, (Object)registered);
        String uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
        ManagedRouteStopTest.assertEquals((Object)"direct://start", (Object)uri);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteStopTest.assertEquals((String)"Should be started", (Object)ServiceStatus.Started.name(), (Object)state);
        String uptime = (String)mbeanServer.getAttribute(on, "Uptime");
        ManagedRouteStopTest.assertNotNull((Object)uptime);
        this.log.info("Uptime: {}", (Object)uptime);
        long uptimeMillis = (Long)mbeanServer.getAttribute(on, "UptimeMillis");
        ManagedRouteStopTest.assertTrue((uptimeMillis > 0L ? 1 : 0) != 0);
        mbeanServer.invoke(on, "stop", null, null);
        registered = mbeanServer.isRegistered(on);
        ManagedRouteStopTest.assertEquals((String)"Should be registered", (Object)true, (Object)registered);
        state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteStopTest.assertEquals((String)"Should be stopped", (Object)ServiceStatus.Stopped.name(), (Object)state);
        uptime = (String)mbeanServer.getAttribute(on, "Uptime");
        ManagedRouteStopTest.assertEquals((Object)"", (Object)uptime);
        uptimeMillis = (Long)mbeanServer.getAttribute(on, "UptimeMillis");
        ManagedRouteStopTest.assertEquals((long)0L, (long)uptimeMillis);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").delayer(10L).to("log:foo")).to("mock:result");
            }
        };
    }
}

