/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.Test;

public class ManagedRouteRemoveWireTapExplicitThreadPoolTest
extends ManagementTestSupport {
    private ExecutorService myThreadPool;

    @Test
    public void testRemove() throws Exception {
        if (ManagedRouteRemoveWireTapExplicitThreadPoolTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"foo\"");
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:tap").expectedMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteRemoveWireTapExplicitThreadPoolTest.assertEquals((String)"Should be started", (Object)ServiceStatus.Started.name(), (Object)state);
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=threadpools,*"), null);
        boolean wireTap = false;
        for (ObjectName name : set) {
            if (!name.toString().contains("wireTap")) continue;
            wireTap = true;
            break;
        }
        ManagedRouteRemoveWireTapExplicitThreadPoolTest.assertFalse((String)"Should not have a wire tap thread pool", (boolean)wireTap);
        mbeanServer.invoke(on, "stop", null, null);
        state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteRemoveWireTapExplicitThreadPoolTest.assertEquals((String)"Should be stopped", (Object)ServiceStatus.Stopped.name(), (Object)state);
        mbeanServer.invoke(on, "remove", null, null);
        boolean registered = mbeanServer.isRegistered(on);
        ManagedRouteRemoveWireTapExplicitThreadPoolTest.assertFalse((String)"Route mbean should have been unregistered", (boolean)registered);
        set = mbeanServer.queryNames(new ObjectName("*:type=threadpools,*"), null);
        wireTap = false;
        for (ObjectName name : set) {
            if (!name.toString().contains("wireTap")) continue;
            wireTap = true;
            break;
        }
        ManagedRouteRemoveWireTapExplicitThreadPoolTest.assertFalse((String)"Should not have a wire tap thread pool", (boolean)wireTap);
        ManagedRouteRemoveWireTapExplicitThreadPoolTest.assertFalse((String)"Thread pool should not be shutdown", (boolean)this.myThreadPool.isShutdown());
        this.myThreadPool.shutdownNow();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ManagedRouteRemoveWireTapExplicitThreadPoolTest.this.myThreadPool = Executors.newFixedThreadPool(1);
                this.from("seda:foo").routeId("foo").wireTap("direct:tap").executorService(ManagedRouteRemoveWireTapExplicitThreadPoolTest.this.myThreadPool).to("mock:result");
                this.from("direct:tap").routeId("tap").to("mock:tap");
            }
        };
    }
}

