/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.Test;

public class ManagedRouteRemoveRouteScopedErrorHandlerTest
extends ManagementTestSupport {
    @Test
    public void testRemove() throws Exception {
        if (ManagedRouteRemoveRouteScopedErrorHandlerTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteRemoveRouteScopedErrorHandlerTest.getRouteObjectName(mbeanServer);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteRemoveRouteScopedErrorHandlerTest.assertEquals((String)"Should be started", (Object)ServiceStatus.Started.name(), (Object)state);
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=errorhandlers,*"), null);
        ManagedRouteRemoveRouteScopedErrorHandlerTest.assertEquals((long)1L, (long)set.size());
        mbeanServer.invoke(on, "stop", null, null);
        state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteRemoveRouteScopedErrorHandlerTest.assertEquals((String)"Should be stopped", (Object)ServiceStatus.Stopped.name(), (Object)state);
        mbeanServer.invoke(on, "remove", null, null);
        boolean registered = mbeanServer.isRegistered(on);
        ManagedRouteRemoveRouteScopedErrorHandlerTest.assertFalse((String)"Route mbean should have been unregistered", (boolean)registered);
        set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedRouteRemoveRouteScopedErrorHandlerTest.assertEquals((long)0L, (long)set.size());
        set = mbeanServer.queryNames(new ObjectName("*:type=errorhandlers,*"), null);
        ManagedRouteRemoveRouteScopedErrorHandlerTest.assertEquals((long)0L, (long)set.size());
    }

    static ObjectName getRouteObjectName(MBeanServer mbeanServer) throws Exception {
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedRouteRemoveRouteScopedErrorHandlerTest.assertEquals((long)1L, (long)set.size());
        return set.iterator().next();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:foo").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead")).to("mock:result");
            }
        };
    }
}

