/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.awaitility.Awaitility;
import org.junit.Test;

public class ManagedRoutePerformanceCounterTest
extends ManagementTestSupport {
    @Test
    public void testPerformanceCounterStats() throws Exception {
        if (ManagedRoutePerformanceCounterTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"route1\"");
        Long delta = (Long)mbeanServer.getAttribute(on, "DeltaProcessingTime");
        ManagedRoutePerformanceCounterTest.assertEquals((long)0L, (long)delta.intValue());
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.asyncSendBody("direct:start", (Object)"Hello World");
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> {
            Long num = (Long)mbeanServer.getAttribute(on, "ExchangesInflight");
            return num == 1L;
        });
        this.assertMockEndpointsSatisfied();
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            Long completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
            ManagedRoutePerformanceCounterTest.assertEquals((long)1L, (long)completed);
        });
        delta = (Long)mbeanServer.getAttribute(on, "DeltaProcessingTime");
        Long last = (Long)mbeanServer.getAttribute(on, "LastProcessingTime");
        Long total = (Long)mbeanServer.getAttribute(on, "TotalProcessingTime");
        ManagedRoutePerformanceCounterTest.assertNotNull((Object)delta);
        ManagedRoutePerformanceCounterTest.assertTrue((String)("Should take around 1 sec: was " + last), (last > 900L ? 1 : 0) != 0);
        ManagedRoutePerformanceCounterTest.assertTrue((String)("Should take around 1 sec: was " + total), (total > 900L ? 1 : 0) != 0);
        this.template.sendBody("direct:start", (Object)"Bye World");
        Long completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        ManagedRoutePerformanceCounterTest.assertEquals((long)2L, (long)completed);
        delta = (Long)mbeanServer.getAttribute(on, "DeltaProcessingTime");
        last = (Long)mbeanServer.getAttribute(on, "LastProcessingTime");
        total = (Long)mbeanServer.getAttribute(on, "TotalProcessingTime");
        ManagedRoutePerformanceCounterTest.assertNotNull((Object)delta);
        ManagedRoutePerformanceCounterTest.assertTrue((String)("Should take around 1 sec: was " + last), (last > 900L ? 1 : 0) != 0);
        ManagedRoutePerformanceCounterTest.assertTrue((String)("Should be around 2 sec now: was " + total), (total > 1900L ? 1 : 0) != 0);
        Date reset = (Date)mbeanServer.getAttribute(on, "ResetTimestamp");
        ManagedRoutePerformanceCounterTest.assertNotNull((Object)reset);
        Date lastFailed = (Date)mbeanServer.getAttribute(on, "LastExchangeFailureTimestamp");
        Date firstFailed = (Date)mbeanServer.getAttribute(on, "FirstExchangeFailureTimestamp");
        ManagedRoutePerformanceCounterTest.assertNull((Object)lastFailed);
        ManagedRoutePerformanceCounterTest.assertNull((Object)firstFailed);
        Long inFlight = (Long)mbeanServer.getAttribute(on, "ExchangesInflight");
        ManagedRoutePerformanceCounterTest.assertEquals((long)0L, (long)inFlight);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).delay(1000L).to("mock:result");
            }
        };
    }
}

