/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.awaitility.Awaitility;
import org.junit.Test;

public class ManagedRouteNoAutoStartupTest
extends ManagementTestSupport {
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").noAutoStartup().to("mock:result");
            }
        };
    }

    static ObjectName getRouteObjectName(MBeanServer mbeanServer) throws Exception {
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedRouteNoAutoStartupTest.assertEquals((long)1L, (long)set.size());
        return set.iterator().next();
    }

    @Test
    public void testRouteNoAutoStartup() throws Exception {
        if (ManagedRouteNoAutoStartupTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteNoAutoStartupTest.getRouteObjectName(mbeanServer);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteNoAutoStartupTest.assertEquals((String)"Should be stopped", (Object)ServiceStatus.Stopped.name(), (Object)state);
        mbeanServer.invoke(on, "start", null, null);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Long completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
            ManagedRouteNoAutoStartupTest.assertEquals((long)1L, (long)completed);
        });
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=consumers,*"), null);
        ManagedRouteNoAutoStartupTest.assertEquals((String)"Should be 1 consumer", (long)1L, (long)set.size());
        set = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), null);
        ManagedRouteNoAutoStartupTest.assertEquals((String)"Should be 1 processor", (long)1L, (long)set.size());
        mbeanServer.invoke(on, "stop", null, null);
        state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteNoAutoStartupTest.assertEquals((String)"Should be stopped", (Object)ServiceStatus.Stopped.name(), (Object)state);
        set = mbeanServer.queryNames(new ObjectName("*:type=consumers,*"), null);
        ManagedRouteNoAutoStartupTest.assertEquals((String)"Should be 0 consumer", (long)0L, (long)set.size());
        set = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), null);
        ManagedRouteNoAutoStartupTest.assertEquals((String)"Should be 0 processor", (long)0L, (long)set.size());
    }
}

