/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;
import org.w3c.dom.Document;

public class ManagedRouteDumpStatsAsXmlTest
extends ManagementTestSupport {
    @Test
    public void testPerformanceCounterStats() throws Exception {
        if (ManagedRouteDumpStatsAsXmlTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"foo\"");
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.asyncSendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String xml = (String)mbeanServer.invoke(on, "dumpRouteStatsAsXml", new Object[]{false, true}, new String[]{"boolean", "boolean"});
        this.log.info(xml);
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)xml);
        ManagedRouteDumpStatsAsXmlTest.assertNotNull((Object)doc);
        int processors = doc.getDocumentElement().getElementsByTagName("processorStat").getLength();
        ManagedRouteDumpStatsAsXmlTest.assertEquals((long)3L, (long)processors);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").to("log:foo")).id("to-log")).delay(100L).to("mock:result")).id("to-mock");
            }
        };
    }
}

