/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.Test;

public class ManagedRouteAddSecondRouteNotRegisterNewRoutesTest
extends ManagementTestSupport {
    protected RouteBuilder createRouteBuilder() throws Exception {
        this.context.getManagementStrategy().getManagementAgent().setRegisterNewRoutes(Boolean.valueOf(false));
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("foo").to("mock:result");
            }
        };
    }

    @Test
    public void testRouteAddSecondRoute() throws Exception {
        if (ManagedRouteAddSecondRouteNotRegisterNewRoutesTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName route1 = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"foo\"");
        String state = (String)mbeanServer.getAttribute(route1, "State");
        ManagedRouteAddSecondRouteNotRegisterNewRoutesTest.assertEquals((String)"Should be started", (Object)ServiceStatus.Started.name(), (Object)state);
        this.log.info(">>>>>>>>>>>>>>>>> adding 2nd route <<<<<<<<<<<<<<");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:bar").routeId("bar").to("mock:bar");
            }
        });
        this.log.info(">>>>>>>>>>>>>>>>> adding 2nd route DONE <<<<<<<<<<<<<<");
        ObjectName route2 = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"bar\"");
        ManagedRouteAddSecondRouteNotRegisterNewRoutesTest.assertFalse((String)"2nd route should not be registered", (boolean)mbeanServer.isRegistered(route2));
    }
}

