/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.management.MyManagedBean;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.ManagementAgent;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedResourceTest
extends ManagementTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedResourceTest.class);

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").bean(MyManagedBean.class)).id("myManagedBean")).log("${body}")).to("seda:foo")).to("mock:result");
            }
        };
    }

    @Test
    public void testManagedResource() throws Exception {
        if (ManagedResourceTest.isPlatform((String)"aix")) {
            return;
        }
        ManagementAgent managementAgent = this.context.getManagementStrategy().getManagementAgent();
        Assert.assertNotNull((Object)managementAgent);
        MBeanServer mBeanServer = managementAgent.getMBeanServer();
        Assert.assertNotNull((Object)mBeanServer);
        String mBeanServerDefaultDomain = managementAgent.getMBeanServerDefaultDomain();
        Assert.assertEquals((Object)"org.apache.camel", (Object)mBeanServerDefaultDomain);
        String managementName = this.context.getManagementName();
        Assert.assertNotNull((String)"CamelContext should have a management name if JMX is enabled", (Object)managementName);
        LOG.info("managementName = {}", (Object)managementName);
        ObjectName onContext = ObjectName.getInstance(mBeanServerDefaultDomain + ":context=" + managementName + ",type=context,name=\"" + this.context.getName() + "\"");
        Assert.assertTrue((String)"Should be registered", (boolean)mBeanServer.isRegistered(onContext));
        ObjectName onManagedBean = ObjectName.getInstance(mBeanServerDefaultDomain + ":context=" + managementName + ",type=processors,name=\"myManagedBean\"");
        LOG.info("Canonical Name = {}", (Object)onManagedBean.getCanonicalName());
        Assert.assertTrue((String)"Should be registered", (boolean)mBeanServer.isRegistered(onManagedBean));
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.template.sendBody("direct:start", (Object)"Camel Rocks!");
        int camelsSeenCount = (Integer)mBeanServer.getAttribute(onManagedBean, "CamelsSeenCount");
        Assert.assertEquals((long)2L, (long)camelsSeenCount);
        mBeanServer.invoke(onManagedBean, "resetCamelsSeenCount", null, null);
        camelsSeenCount = (Integer)mBeanServer.getAttribute(onManagedBean, "CamelsSeenCount");
        Assert.assertEquals((long)0L, (long)camelsSeenCount);
        String camelId = (String)mBeanServer.getAttribute(onManagedBean, "CamelId");
        ManagedResourceTest.assertEquals((Object)this.context.getName(), (Object)camelId);
        String state = (String)mBeanServer.getAttribute(onManagedBean, "State");
        ManagedResourceTest.assertEquals((Object)"Started", (Object)state);
        String fqn = (String)mBeanServer.getAttribute(onManagedBean, "BeanClassName");
        ManagedResourceTest.assertEquals((Object)MyManagedBean.class.getCanonicalName(), (Object)fqn);
    }
}

