/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class ManagedRegisterRouteTest
extends ManagementTestSupport {
    @Test
    public void testRoutes() throws Exception {
        if (ManagedRegisterRouteTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedRegisterRouteTest.assertEquals((long)1L, (long)set.size());
        ObjectName on = set.iterator().next();
        boolean registered = mbeanServer.isRegistered(on);
        ManagedRegisterRouteTest.assertEquals((String)"Should be registered", (Object)true, (Object)registered);
        String uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
        ManagedRegisterRouteTest.assertEquals((Object)"direct://start", (Object)uri);
        String id = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedRegisterRouteTest.assertEquals((Object)"myRoute", (Object)id);
        String group = (String)mbeanServer.getAttribute(on, "RouteGroup");
        ManagedRegisterRouteTest.assertEquals((Object)"myGroup", (Object)group);
        String desc = (String)mbeanServer.getAttribute(on, "Description");
        ManagedRegisterRouteTest.assertEquals((Object)"my cool route", (Object)desc);
        Long val = (Long)mbeanServer.getAttribute(on, "ExchangesInflight");
        ManagedRegisterRouteTest.assertEquals((long)0L, (long)val);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRegisterRouteTest.assertEquals((String)"Should be started", (Object)ServiceStatus.Started.name(), (Object)state);
        this.context.getRouteController().stopRoute(((RouteDefinition)this.context.getRouteDefinitions().get(0)).getId());
        registered = mbeanServer.isRegistered(on);
        ManagedRegisterRouteTest.assertEquals((String)"Should be registered", (Object)true, (Object)registered);
        state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRegisterRouteTest.assertEquals((String)"Should be stopped", (Object)ServiceStatus.Stopped.name(), (Object)state);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("myRoute").routeGroup("myGroup").description("my cool route")).to("log:foo")).to("mock:result");
            }
        };
    }
}

