/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class ManagedRegisterExchangeStatisticsTest
extends ManagementTestSupport {
    @Test
    public void testExchangesCompletedStatistics() throws Exception {
        if (ManagedRegisterExchangeStatisticsTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"route1\"");
        Long completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        ManagedRegisterExchangeStatisticsTest.assertEquals((long)0L, (long)completed);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        ManagedRegisterExchangeStatisticsTest.assertEquals((long)1L, (long)completed);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }
}

