/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class ManagedRedeliverTest
extends ManagementTestSupport {
    @Test
    public void testRedeliver() throws Exception {
        if (ManagedRedeliverTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        MockEndpoint mock = this.getMockEndpoint("mock:foo");
        mock.expectedMessageCount(1);
        Object out = this.template.requestBody("direct:start", (Object)"Hello World");
        ManagedRedeliverTest.assertEquals((Object)"Error", (Object)out);
        this.assertMockEndpointsSatisfied();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"route1\"");
        Long num = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        ManagedRedeliverTest.assertEquals((long)1L, (long)num);
        num = (Long)mbeanServer.getAttribute(on, "ExchangesFailed");
        ManagedRedeliverTest.assertEquals((long)0L, (long)num);
        num = (Long)mbeanServer.getAttribute(on, "FailuresHandled");
        ManagedRedeliverTest.assertEquals((long)1L, (long)num);
        on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"myprocessor\"");
        num = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        ManagedRedeliverTest.assertEquals((long)0L, (long)num);
        num = (Long)mbeanServer.getAttribute(on, "ExchangesTotal");
        ManagedRedeliverTest.assertEquals((long)5L, (long)num);
        num = (Long)mbeanServer.getAttribute(on, "ExchangesFailed");
        ManagedRedeliverTest.assertEquals((long)5L, (long)num);
        num = (Long)mbeanServer.getAttribute(on, "Redeliveries");
        ManagedRedeliverTest.assertEquals((long)4L, (long)num);
        String first = (String)mbeanServer.getAttribute(on, "FirstExchangeFailureExchangeId");
        ManagedRedeliverTest.assertEquals((Object)((Exchange)mock.getReceivedExchanges().get(0)).getExchangeId(), (Object)first);
        String last = (String)mbeanServer.getAttribute(on, "LastExchangeFailureExchangeId");
        ManagedRedeliverTest.assertEquals((Object)((Exchange)mock.getReceivedExchanges().get(0)).getExchangeId(), (Object)last);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(Exception.class).handled(true).redeliveryDelay(0L).maximumRedeliveries(4).logStackTrace(false).setBody().constant((Object)"Error");
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:foo")).process(exchange -> {
                    this.log.info("Invoking me");
                    throw new IllegalArgumentException("Damn");
                })).id("myprocessor");
            }
        };
    }
}

