/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class ManagedRedeliverRouteOnlyTest
extends ManagementTestSupport {
    @Test
    public void testRedeliver() throws Exception {
        if (ManagedRedeliverRouteOnlyTest.isPlatform((String)"aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        Object out = this.template.requestBody("direct:start", (Object)"Hello World");
        ManagedRedeliverRouteOnlyTest.assertEquals((Object)"Error", (Object)out);
        this.assertMockEndpointsSatisfied();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"route1\"");
        Long num = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        ManagedRedeliverRouteOnlyTest.assertEquals((long)1L, (long)num);
        num = (Long)mbeanServer.getAttribute(on, "ExchangesFailed");
        ManagedRedeliverRouteOnlyTest.assertEquals((long)0L, (long)num);
        num = (Long)mbeanServer.getAttribute(on, "FailuresHandled");
        ManagedRedeliverRouteOnlyTest.assertEquals((long)1L, (long)num);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ManagedRedeliverRouteOnlyTest.this.context.getManagementStrategy().getManagementAgent().setStatisticsLevel(ManagementStatisticsLevel.RoutesOnly);
                this.onException(Exception.class).handled(true).redeliveryDelay(0L).maximumRedeliveries(4).logStackTrace(false).setBody().constant((Object)"Error");
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:foo")).process(exchange -> {
                    this.log.info("Invoking me");
                    throw new IllegalArgumentException("Damn");
                })).id("myprocessor");
            }
        };
    }
}

