/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.Test;

public class ManagedRecipientListTest
extends ManagementTestSupport {
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.init();
        context.getManagementStrategy().getManagementAgent().setStatisticsLevel(ManagementStatisticsLevel.Extended);
        return context;
    }

    @Test
    public void testManageRecipientList() throws Exception {
        if (ManagedRecipientListTest.isPlatform((String)"aix")) {
            return;
        }
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMessageCount(2);
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "whereto", (Object)"mock:foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "whereto", (Object)"mock:foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hi World", "whereto", (Object)"mock:bar");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedRecipientListTest.assertEquals((Object)"route1", (Object)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedRecipientListTest.assertEquals((Object)"camel-1", (Object)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRecipientListTest.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        Boolean parallel = (Boolean)mbeanServer.getAttribute(on, "ParallelProcessing");
        ManagedRecipientListTest.assertEquals((Object)false, (Object)parallel);
        String lan = (String)mbeanServer.getAttribute(on, "ExpressionLanguage");
        ManagedRecipientListTest.assertEquals((Object)"header", (Object)lan);
        String uri = (String)mbeanServer.getAttribute(on, "Expression");
        ManagedRecipientListTest.assertEquals((Object)"whereto", (Object)uri);
        TabularData data = (TabularData)mbeanServer.invoke(on, "extendedInformation", null, null);
        ManagedRecipientListTest.assertNotNull((Object)data);
        ManagedRecipientListTest.assertEquals((long)2L, (long)data.size());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").recipientList((Expression)this.header("whereto")).id("mysend");
            }
        };
    }
}

